/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.spring;

import java.util.HashMap;
import java.util.Map;
import org.test4j.mock.Stubs;

public class BeanRegister {
    final Map<String, Class> beans = new HashMap<String, Class>();
    final Map<String, Object> faker = new HashMap<String, Object>();

    public BeanRegister bean(String name, Object beanOrKlass) {
        if (beanOrKlass == null) {
            return this;
        }
        if (beanOrKlass instanceof Class) {
            this.beans.put(name, (Class)beanOrKlass);
        } else {
            this.faker.put(name, beanOrKlass);
        }
        return this;
    }

    public BeanRegister bean(Class ... classes) {
        for (Class klass : classes) {
            this.bean(BeanRegister.camelName(klass), (Object)klass);
        }
        return this;
    }

    public BeanRegister stub(String name, Class klass) {
        if (klass == null) {
            return this;
        }
        Object stub = Stubs.fake(klass);
        Stubs.nilFields(stub, new Class[0]);
        this.faker.put(name, stub);
        return this;
    }

    public BeanRegister stub(Class ... classes) {
        for (Class klass : classes) {
            this.stub(BeanRegister.camelName(klass), klass);
        }
        return this;
    }

    public static String camelName(Class klass) {
        String name = klass.getSimpleName();
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }
}

