/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.spring;

import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.test4j.annotations.Beans;
import org.test4j.annotations.Mocks;
import org.test4j.integration.spring.BeanRegister;
import org.test4j.mock.faking.util.ClassLoad;

public class BeanRegisterProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final BeanRegister register;

    public BeanRegisterProcessor(BeanRegister register) {
        this.register = register;
    }

    public BeanRegisterProcessor(String registerClass) {
        try {
            this.register = (BeanRegister)Class.forName(registerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("getRegister error:" + e.getMessage(), e);
        }
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        for (String string : this.register.faker.keySet()) {
            if (!registry.containsBeanDefinition(string)) continue;
            registry.removeBeanDefinition(string);
        }
        for (Map.Entry entry : this.register.beans.entrySet()) {
            String beanName = (String)entry.getKey();
            if (registry.containsBeanDefinition(beanName)) {
                registry.removeBeanDefinition(beanName);
            }
            GenericBeanDefinition gbd = new GenericBeanDefinition();
            gbd.setBeanClass((Class)entry.getValue());
            registry.registerBeanDefinition(beanName, (BeanDefinition)gbd);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (Map.Entry<String, Object> entry : this.register.faker.entrySet()) {
            beanFactory.registerSingleton(entry.getKey(), entry.getValue());
        }
    }

    static void registerByMocks(DefaultListableBeanFactory factory, Class tested) {
        LinkedList<Class> queue = new LinkedList<Class>();
        queue.offer(tested);
        while (!queue.isEmpty()) {
            Beans beans;
            Class klass = (Class)queue.poll();
            BeanRegisterProcessor.findSuperClass(queue, klass);
            Mocks mocks = klass.getDeclaredAnnotation(Mocks.class);
            if (mocks != null && (mocks.beans().length > 0 || mocks.names().length > 0)) {
                BeanRegisterProcessor.addBeanRegisterDefinition(factory, klass.getName() + mocks.suffixBeanRegister());
            }
            if ((beans = klass.getDeclaredAnnotation(Beans.class)) == null || beans.beans().length <= 0 && beans.names().length <= 0) continue;
            BeanRegisterProcessor.addBeanRegisterDefinition(factory, klass.getName() + beans.suffixBeanRegister());
        }
    }

    private static void addBeanRegisterDefinition(DefaultListableBeanFactory factory, String beanRegisterClass) {
        if (!ClassLoad.isInClasspath(beanRegisterClass)) {
            return;
        }
        try {
            GenericBeanDefinition gbd = new GenericBeanDefinition();
            gbd.setBeanClass(BeanRegisterProcessor.class);
            gbd.getConstructorArgumentValues().addGenericArgumentValue((Object)beanRegisterClass);
            factory.registerBeanDefinition(beanRegisterClass, (BeanDefinition)gbd);
        }
        catch (Exception e) {
            throw new RuntimeException("add BeanRegister[" + beanRegisterClass + "] bean definition error:" + e.getMessage(), e);
        }
    }

    private static void findSuperClass(Queue<Class> queue, Class klass) {
        Class<?>[] interfaces;
        for (Class<?> a : interfaces = klass.getInterfaces()) {
            queue.offer(a);
        }
        Class a = klass.getSuperclass();
        if (a != null && !Objects.equals(a, Object.class)) {
            queue.offer(klass.getSuperclass());
        }
    }
}

