/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.testng;

import java.lang.reflect.Method;
import org.test4j.Context;
import org.test4j.integration.ListenerFactory;
import org.test4j.mock.faking.util.StackTrace;
import org.test4j.mock.startup.JavaAgentHits;
import org.testng.IExecutionListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestException;
import org.testng.annotations.Test;

public final class TestNGListener
implements IInvokedMethodListener,
IExecutionListener {
    public void beforeInvocation(IInvokedMethod invokedMethod, ITestResult testResult) {
        Context.clearNoMockingZone();
        ITestNGMethod testNGMethod = testResult.getMethod();
        if (!invokedMethod.isTestMethod()) {
            this.beforeConfigurationMethod(testNGMethod, testResult);
        } else if (this.isTestNgResult(testResult)) {
            Method testMethod = testNGMethod.getConstructorOrMethod().getMethod();
            ListenerFactory.beforeExecute(testNGMethod.getInstance(), testMethod);
        }
    }

    public void afterInvocation(IInvokedMethod invokedMethod, ITestResult testResult) {
        if (invokedMethod.isTestMethod()) {
            ITestNGMethod testNGMethod = invokedMethod.getTestMethod();
            try {
                Throwable e = testResult.getThrowable();
                Method testMethod = testNGMethod.getConstructorOrMethod().getMethod();
                ListenerFactory.afterExecute(testNGMethod.getInstance(), testMethod, e);
            }
            catch (Throwable t) {
                this.setResult(invokedMethod, testResult, t);
            }
        } else {
            TestNGListener.filterTestResultThrowable(testResult);
        }
    }

    public void onExecutionFinish() {
        ListenerFactory.afterAll();
    }

    private void beforeConfigurationMethod(ITestNGMethod method, ITestResult testResult) {
        if (method.isBeforeClassConfiguration()) {
            Class testClass = testResult.getTestClass().getRealClass();
            ListenerFactory.beforeAll(testClass);
        } else if (method.isBeforeMethodConfiguration()) {
            ListenerFactory.beforeMethod(method.getInstance());
        } else if (method.isAfterClassConfiguration()) {
            ListenerFactory.afterMethod();
        } else if (!method.isAfterMethodConfiguration()) {
            ListenerFactory.afterAll();
        }
    }

    private static void filterTestResultThrowable(ITestResult testResult) {
        ITestNGMethod method = testResult.getMethod();
        if (method.isAfterMethodConfiguration()) {
            StackTrace.filterStackTrace(testResult.getThrowable());
        }
    }

    private static boolean isExpectedException(IInvokedMethod invokedMethod, Throwable thrownByTest) {
        Method testMethod = invokedMethod.getTestMethod().getConstructorOrMethod().getMethod();
        Class[] expectedExceptions = testMethod.getAnnotation(Test.class).expectedExceptions();
        Class<?> thrownExceptionType = thrownByTest.getClass();
        for (Class expectedException : expectedExceptions) {
            if (!expectedException.isAssignableFrom(thrownExceptionType)) continue;
            return true;
        }
        return false;
    }

    private void setResult(IInvokedMethod invokedMethod, ITestResult testResult, Throwable throwable) {
        StackTrace.filterStackTrace(throwable);
        Throwable thrownByTest = testResult.getThrowable();
        StackTrace.filterStackTrace(thrownByTest);
        if (thrownByTest instanceof TestException && TestNGListener.isExpectedException(invokedMethod, throwable)) {
            testResult.setThrowable(null);
            testResult.setStatus(1);
        } else if (thrownByTest == null || testResult.isSuccess() && throwable != thrownByTest) {
            testResult.setThrowable(throwable);
            testResult.setStatus(2);
        }
    }

    private boolean isTestNgResult(ITestResult testResult) {
        Object testInstance = testResult.getInstance();
        Class testClass = testResult.getTestClass().getRealClass();
        return testInstance != null && testInstance.getClass() == testClass;
    }

    static {
        JavaAgentHits.message();
    }
}

