/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock;

import java.lang.reflect.Method;
import org.test4j.mock.faking.meta.FakeStates;
import org.test4j.mock.faking.meta.TimesVerify;
import org.test4j.module.Test4JListener;

public class MockListener
implements Test4JListener {
    private static ThreadLocal<Long> savePointForTestClass = new ThreadLocal();
    private static ThreadLocal<Long> savePointForTestMethod = new ThreadLocal();
    private static ThreadLocal<Long> savePointForTestExecute = new ThreadLocal();

    @Override
    public void beforeAll(Class testClass) {
        savePointForTestClass.set(FakeStates.getMaxFakeId());
    }

    @Override
    public void beforeMethod(Object target) {
        MockListener.rollback(savePointForTestExecute, null);
        MockListener.rollback(savePointForTestMethod, FakeStates.getMaxFakeId());
        TimesVerify.initVerify();
    }

    @Override
    public void beforeExecute(Object target, Method method) {
        MockListener.rollback(savePointForTestExecute, FakeStates.getMaxFakeId());
    }

    @Override
    public void afterExecute(Object target, Method method, Throwable e) {
        MockListener.rollback(savePointForTestExecute, null);
        TimesVerify.verify();
    }

    @Override
    public void afterMethod() {
        MockListener.rollback(savePointForTestExecute, null);
        MockListener.rollback(savePointForTestMethod, null);
    }

    @Override
    public void afterAll() {
        MockListener.rollback(savePointForTestExecute, null);
        MockListener.rollback(savePointForTestMethod, null);
        MockListener.rollback(savePointForTestClass, null);
    }

    private static void rollback(ThreadLocal<Long> savePoint, Long newSavePoint) {
        FakeStates.rollback(savePoint.get());
        savePoint.set(newSavePoint);
    }
}

