/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.fluent;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.test4j.mock.Invocation;
import org.test4j.mock.MockUp;
import org.test4j.mock.faking.fluent.FakeFunction;
import org.test4j.mock.faking.fluent.FakeResult;
import org.test4j.mock.faking.fluent.MethodBehaviors;
import org.test4j.mock.faking.fluent.MockBehavior;
import org.test4j.mock.faking.meta.FakeMethod;
import org.test4j.mock.faking.meta.FakeMethods;
import org.test4j.mock.faking.meta.FakeStates;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.faking.util.ObjectIdentify;
import org.test4j.mock.faking.util.ReflectUtility;

public class FluentMockUp<T>
extends MockUp<T> {
    protected final MethodBehaviors behaviors;
    private Map<String, Consumer<Invocation>> parasAsserts = new HashMap<String, Consumer<Invocation>>();
    private Map<String, BiConsumer<Invocation, Object>> resultAsserts = new HashMap<String, BiConsumer<Invocation, Object>>();

    public FluentMockUp() {
        this.behaviors = new MethodBehaviors(this.declaredToFake);
    }

    public FluentMockUp(Class declaredToFake) {
        super(declaredToFake, new Object[0]);
        this.behaviors = new MethodBehaviors(this.declaredToFake);
    }

    public FluentMockUp(String fullClassName, Object[] objects) {
        super(fullClassName, (Object[])ObjectIdentify.identities(objects));
        this.behaviors = new MethodBehaviors(this.declaredToFake);
    }

    public FluentMockUp(Class declaredClass, MethodBehaviors behaviors, Set<Integer> fakedHashCodes) {
        super(declaredClass, fakedHashCodes);
        this.behaviors = behaviors;
    }

    @Override
    protected final void initFakeMethods() {
    }

    public final void apply() {
        this.init();
        this.initFluentMethods();
    }

    private void initFluentMethods() {
        Set<MethodId> metas = this.behaviors.getMethodIds();
        FakeMethods fakeMethods = new FakeMethods(this.fakedSeqNo);
        for (MethodId meta : metas) {
            fakeMethods.add(new FakeMethod(this, meta));
        }
        FakeStates.register(fakeMethods);
    }

    protected void init() {
    }

    public void mockMethod(String realClass, String name, String desc, int index, FakeFunction fake) {
        this.behaviors.addMockBehavior(realClass, name, desc, index, fake);
    }

    public void mockReturn(String realClass, String name, String desc, int index, Object result) {
        this.behaviors.addMockBehavior(realClass, name, desc, index, FakeResult.value(result));
    }

    public void mockThrows(String realClass, String name, String desc, int index, Throwable e) {
        this.behaviors.addMockBehavior(realClass, name, desc, index, FakeResult.eject(e));
    }

    public Object invoke(Invocation invocation, String methodDesc, Object[] args) {
        int index = invocation.getInvokedTimes();
        this.assertBefore(methodDesc, invocation);
        MockBehavior behavior = this.getBehavior(index, methodDesc);
        if (behavior == null) {
            Object result = invocation.proceed(args);
            return this.assertAfter(methodDesc, invocation, result);
        }
        if (behavior instanceof FakeFunction) {
            return ((FakeFunction)behavior).doFake(invocation);
        }
        FakeResult result = (FakeResult)behavior;
        if (result.isThrowable()) {
            return ReflectUtility.doThrow((Throwable)result.getResult());
        }
        return this.assertAfter(methodDesc, invocation, result.getResult());
    }

    void addAssertMethodParas(String methodDesc, Consumer<Invocation> asserts) {
        this.parasAsserts.put(methodDesc, asserts);
    }

    void addAssertMethodResult(String methodDesc, BiConsumer<Invocation, Object> asserts) {
        this.resultAsserts.put(methodDesc, asserts);
    }

    private void assertBefore(String methodDesc, Invocation invocation) {
        Consumer<Invocation> asserts = this.parasAsserts.get(methodDesc);
        if (asserts != null) {
            asserts.accept(invocation);
        }
    }

    private Object assertAfter(String methodDesc, Invocation invocation, Object result) {
        BiConsumer<Invocation, Object> asserts = this.resultAsserts.get(methodDesc);
        if (asserts != null) {
            asserts.accept(invocation, result);
        }
        return result;
    }

    private MockBehavior getBehavior(int index, String methodDesc) {
        Map methods = (Map)this.behaviors.get(methodDesc);
        if (methods == null || methods.isEmpty()) {
            return null;
        }
        MockBehavior behavior = (MockBehavior)methods.get(index);
        if (behavior == null) {
            behavior = (MockBehavior)methods.get(0);
        }
        return behavior;
    }

    public String getFakeClass(String realClass) {
        if (realClass == null) {
            return this.declaredToFake.getName().replace('.', '/');
        }
        return realClass;
    }
}

