/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.fluent;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.test4j.mock.Invocation;
import org.test4j.mock.faking.fluent.FakeFunction;
import org.test4j.mock.faking.fluent.FluentMockUp;
import org.test4j.mock.faking.meta.MethodId;

public class MockMethod<R> {
    protected final FluentMockUp mockUp;
    private final String realClass;
    private final String name;
    private final String desc;
    private AtomicInteger index = new AtomicInteger(0);
    public static final int INDEX_REST_BEHAVIOR = 0;

    public MockMethod(FluentMockUp mockUp, String realClass, String name, String desc) {
        this.mockUp = mockUp;
        this.realClass = realClass;
        this.name = name;
        this.desc = desc;
    }

    public MockMethod<R> assertParameters(Consumer<Invocation> asserts) {
        String methodDesc = MethodId.buildMethodDesc(this.name, this.desc);
        this.mockUp.addAssertMethodParas(methodDesc, asserts);
        this.placeHolder();
        return this;
    }

    public MockMethod<R> assertResult(BiConsumer<Invocation, R> asserts) {
        String methodDesc = MethodId.buildMethodDesc(this.name, this.desc);
        this.mockUp.addAssertMethodResult(methodDesc, asserts);
        this.placeHolder();
        return this;
    }

    public MockMethod<R> thenReturn(R ... values) {
        for (R value : values) {
            this.mockUp.mockReturn(this.realClass, this.name, this.desc, this.index.incrementAndGet(), value);
        }
        this.mockUp.apply();
        return this;
    }

    public MockMethod<R> thenReturn(int[] times, R ... values) {
        int max = 0;
        for (int index = 0; index < times.length; ++index) {
            R value = this.getValue(values, index);
            this.mockUp.mockReturn(this.realClass, this.name, this.desc, times[index], value);
            max = Math.max(max, times[index]);
        }
        this.setIncreaseTimes(max);
        this.mockUp.apply();
        return this;
    }

    public void restReturn(R value) {
        this.mockUp.mockReturn(this.realClass, this.name, this.desc, 0, value);
        this.mockUp.apply();
    }

    public MockMethod<R> thenThrows(Throwable ... es) {
        for (Throwable e : es) {
            this.mockUp.mockThrows(this.realClass, this.name, this.desc, this.index.incrementAndGet(), e);
        }
        this.mockUp.apply();
        return this;
    }

    public MockMethod<R> thenThrows(int[] times, Throwable ... es) {
        int max = 0;
        for (int index = 0; index < times.length; ++index) {
            Throwable e = this.getValue(es, index);
            this.mockUp.mockThrows(this.realClass, this.name, this.desc, times[index], e);
            max = Math.max(max, times[index]);
        }
        this.setIncreaseTimes(max);
        this.mockUp.apply();
        return this;
    }

    public void restThrows(Throwable e) {
        this.mockUp.mockThrows(this.realClass, this.name, this.desc, 0, e);
        this.mockUp.apply();
    }

    public MockMethod<R> thenAnswer(FakeFunction<R> fake) {
        if (fake == null) {
            throw new RuntimeException("The parameter[fake] of restAnswer method can't be null.");
        }
        this.mockUp.mockMethod(this.realClass, this.name, this.desc, this.index.incrementAndGet(), fake);
        this.mockUp.apply();
        return this;
    }

    public MockMethod<R> thenAnswer(int timeSeq, FakeFunction<R> fake) {
        if (fake == null) {
            throw new RuntimeException("The parameter[fake] of restAnswer method can't be null.");
        }
        return this.thenAnswer(new int[]{timeSeq}, fake);
    }

    public MockMethod<R> thenAnswer(int[] times, FakeFunction<R> fake) {
        if (fake == null) {
            throw new RuntimeException("The parameter[fake] of restAnswer method can't be null.");
        }
        int max = 0;
        for (int index = 0; index < times.length; ++index) {
            this.mockUp.mockMethod(this.realClass, this.name, this.desc, times[index], fake);
            max = Math.max(max, times[index]);
        }
        this.setIncreaseTimes(max);
        this.mockUp.apply();
        return this;
    }

    public void restAnswer(FakeFunction<R> fake) {
        if (fake == null) {
            throw new RuntimeException("The parameter[fake] of restAnswer method can't be null.");
        }
        this.mockUp.mockMethod(this.realClass, this.name, this.desc, 0, fake);
        this.mockUp.apply();
    }

    private <A> A getValue(A[] values, int index) {
        if (values == null) {
            return null;
        }
        int size = values.length;
        if (size == 0) {
            return null;
        }
        return index < size ? values[index] : values[size - 1];
    }

    private void setIncreaseTimes(int max) {
        if (this.index.get() < max) {
            this.index.set(max);
        }
    }

    private void placeHolder() {
        this.mockUp.mockReturn(this.realClass, this.name, this.desc, -1, null);
        this.mockUp.apply();
    }
}

