/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.fluent;

import org.test4j.mock.faking.fluent.FluentMockUp;
import org.test4j.mock.faking.fluent.MockMethod;
import org.test4j.mock.faking.meta.TimesVerify;

public class MockMethodWithTimes<R>
extends MockMethod<R> {
    private final String classMethod;

    public MockMethodWithTimes(FluentMockUp mockUp, String realClass, String name, String desc) {
        super(mockUp, realClass, name, desc);
        this.classMethod = mockUp.getFakeClass(realClass) + "#" + name + desc;
    }

    public MockMethod<R> min(int times) {
        TimesVerify.min(this.classMethod, times);
        this.mockUp.apply();
        return this;
    }

    public MockMethod<R> max(int times) {
        TimesVerify.max(this.classMethod, times);
        this.mockUp.apply();
        return this;
    }

    public void never() {
        TimesVerify.never(this.classMethod);
        this.mockUp.apply();
    }

    public MockMethod<R> between(int min, int max) {
        TimesVerify.between(this.classMethod, min, max);
        this.mockUp.apply();
        return this;
    }

    public MockMethod<R> just(int times) {
        TimesVerify.just(this.classMethod, times);
        this.mockUp.apply();
        return this;
    }
}

