/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.meta;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.test4j.mock.faking.modifier.FakeTransformer;
import org.test4j.mock.faking.util.ClassLoad;
import org.test4j.mock.faking.util.TypeUtility;
import org.test4j.mock.startup.Startup;

public abstract class AbstractFake {
    private static final AtomicLong FakeSequence;
    protected final Class declaredToFake;
    protected final Set<Integer> fakedHashCodes = new HashSet<Integer>();
    protected final long fakedSeqNo = FakeSequence.incrementAndGet();

    protected AbstractFake(Integer[] fakedHashCodes) {
        Class<?> clazz = this.getClass();
        this.addFakedHashCodes(fakedHashCodes);
        Type targetType = TypeUtility.getTypeToFake(clazz);
        this.declaredToFake = TypeUtility.getClassType(targetType);
        this.applyFake();
    }

    protected AbstractFake(String fullClassName, Integer[] fakedHashCodes) {
        this(ClassLoad.loadClass(fullClassName), fakedHashCodes);
    }

    protected AbstractFake(Class declaredToFake, Integer[] fakedHashCodes) {
        this.declaredToFake = declaredToFake;
        this.addFakedHashCodes(fakedHashCodes);
        this.applyFake();
    }

    private void addFakedHashCodes(Integer[] fakedHashCodes) {
        if (fakedHashCodes == null || fakedHashCodes.length == 0) {
            return;
        }
        Arrays.stream(fakedHashCodes).filter(code -> code != null).forEach(this.fakedHashCodes::add);
    }

    protected AbstractFake(Class declaredToFake, Set<Integer> fakedHashCodes) {
        this.declaredToFake = declaredToFake;
        this.fakedHashCodes.addAll(fakedHashCodes);
        this.applyFake();
    }

    protected void applyFake() {
        FakeTransformer.applyFakes(this.declaredToFake);
    }

    static {
        Startup.verifyInitialization();
        FakeSequence = new AtomicLong(0L);
    }
}

