/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.meta;

import g_asm.org.objectweb.asm.AnnotationVisitor;
import g_asm.org.objectweb.asm.ClassReader;
import g_asm.org.objectweb.asm.ClassVisitor;
import g_asm.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.List;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.faking.modifier.FakeTransformer;
import org.test4j.mock.faking.util.ClassFile;
import org.test4j.mock.faking.util.TypeDesc;
import org.test4j.mock.faking.util.TypeUtility;

public final class ClassMeta {
    private final Class declareToFake;
    public final List<MethodId> methods;

    public ClassMeta(Class declareToFake, Class fakeClass) {
        this.declareToFake = declareToFake;
        byte[] bytes = ClassFile.readBytesFromClassFile(fakeClass);
        ClassReader classReader = new ClassReader(bytes);
        this.methods = this.findMethods(classReader);
    }

    private List<MethodId> findMethods(ClassReader classReader) {
        final ArrayList<MethodId> methods = new ArrayList<MethodId>();
        classReader.accept(new ClassVisitor(458752){

            public MethodVisitor visitMethod(int access, final String methodName, final String paraDesc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, methodName, paraDesc, signature, exceptions);
                return new MethodVisitor(458752, mv){

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        if (!TypeDesc.T_Mock.DESC.equals(descriptor)) {
                            return super.visitAnnotation(descriptor, visible);
                        }
                        methods.add(ClassMeta.this.buildMethodId(methodName, paraDesc));
                        return super.visitAnnotation(descriptor, visible);
                    }
                };
            }
        }, 8);
        return methods;
    }

    private MethodId buildMethodId(String name, String descriptor) {
        String methodDesc = MethodId.buildMethodDesc(name, descriptor);
        Class superClass = this.declareToFake;
        while (ClassFile.notObjectOrProxy(superClass)) {
            String classDesc = TypeUtility.classPath(superClass);
            Boolean isStatic = FakeTransformer.findMethodInFaked(classDesc, methodDesc);
            if (isStatic == null) {
                superClass = superClass.getSuperclass();
                continue;
            }
            return new MethodId(isStatic != false ? superClass : this.declareToFake, superClass, name, descriptor);
        }
        return new MethodId(this.declareToFake, null, name, descriptor);
    }
}

