/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.meta;

import g_asm.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.test4j.mock.Invocation;
import org.test4j.mock.MockUp;
import org.test4j.mock.faking.meta.AbstractFake;
import org.test4j.mock.faking.meta.FakeInvocation;
import org.test4j.mock.faking.meta.MethodId;

public class FakeMethod {
    public final AbstractFake fake;
    public final MethodId meta;
    private Method mockMethod;
    private boolean hasMatchingRealMethod;
    private final AtomicInteger invocationCount = new AtomicInteger(0);
    private ThreadLocal<Invocation> proceedingInvocation = new ThreadLocal();

    public FakeMethod(AbstractFake fake, MethodId meta) {
        this.fake = fake;
        this.meta = meta;
        this.hasMatchingRealMethod = false;
    }

    public Method findMockMethod() {
        if (this.mockMethod != null) {
            return this.mockMethod;
        }
        CharSequence[] types = this.meta.getParaTypeNames();
        Class<?> aClass = this.fake.getClass();
        while (this.mockMethod == null && MockUp.class.isAssignableFrom(aClass) && !aClass.equals(MockUp.class)) {
            Method[] methods;
            for (Method method : methods = aClass.getDeclaredMethods()) {
                if (!Objects.equals(this.meta.name, method.getName()) || !this.matchParas(method, (String[])types)) continue;
                this.mockMethod = method;
                break;
            }
            aClass = aClass.getSuperclass();
        }
        if (this.mockMethod == null) {
            String desc = this.meta.name + "(" + String.join((CharSequence)", ", types) + ")";
            throw new IllegalArgumentException("No compatible method found: " + desc);
        }
        return this.mockMethod;
    }

    private boolean matchParas(Method method, String[] types) {
        int count = method.getParameterCount();
        if (count != types.length) {
            return false;
        }
        Class<?>[] pTypes = method.getParameterTypes();
        for (int index = 0; index < count; ++index) {
            String metaTypeName = types[index];
            String methodParaType = Type.getType(pTypes[index]).getClassName();
            if (Objects.equals(metaTypeName, methodParaType)) continue;
            return false;
        }
        return true;
    }

    public boolean isProceeding() {
        FakeInvocation invocation = this.getProceedingInvocation();
        if (invocation != null && invocation.isProceeding()) {
            invocation.setProceeding(false);
            return true;
        }
        this.invocationCount.incrementAndGet();
        return false;
    }

    public int getTimesInvoked() {
        return this.invocationCount.get();
    }

    public void setProceedingInvocation(Invocation invocation) {
        this.proceedingInvocation.set(invocation);
    }

    public FakeInvocation getProceedingInvocation() {
        return (FakeInvocation)this.proceedingInvocation.get();
    }

    public void setProceedingInvocation4NonRecursive(Invocation invocation) {
        ((FakeInvocation)invocation).setProceeding(true);
        this.proceedingInvocation.set(invocation);
    }

    public void clearProceedIndicator() {
        this.proceedingInvocation.set(null);
    }

    public boolean isHasMatchingRealMethod() {
        return this.hasMatchingRealMethod;
    }
}

