/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.test4j.mock.faking.meta.MethodId;

public class TimesVerify {
    private static final ThreadLocal<Map<String, Integer>> invokedTimes = new InheritableThreadLocal<Map<String, Integer>>();
    private static final ThreadLocal<List<TimesVerify>> timesVerifier = new InheritableThreadLocal<List<TimesVerify>>();
    private final String classMethod;
    private int min;
    private int max;

    public TimesVerify(String classMethod, int min, int max) {
        int index = classMethod.indexOf(41);
        this.classMethod = classMethod.substring(0, index + 1);
        this.min = min;
        this.max = max;
    }

    public void verifyTimes() {
        int times = Optional.ofNullable(invokedTimes.get()).map(m -> (Integer)m.get(this.classMethod)).orElse(0);
        if (times < this.min) {
            throw new AssertionError((Object)String.format("Method[%s] are expected to be called at least %d times, but be called %d times.", this.classMethod, this.min, times));
        }
        if (times > this.max) {
            throw new AssertionError((Object)String.format("Method[%s] are expected to be called and at most %d times, but be called %d times.", this.classMethod, this.max, times));
        }
    }

    private static void add(TimesVerify timesVerify) {
        if (timesVerifier.get() == null) {
            return;
        }
        timesVerifier.get().add(timesVerify);
    }

    public static void never(String classMethod) {
        TimesVerify.add(new TimesVerify(classMethod, 0, 0));
    }

    public static void min(String classMethod, int min) {
        TimesVerify.add(new TimesVerify(classMethod, min, Integer.MAX_VALUE));
    }

    public static void max(String classMethod, int max) {
        TimesVerify.add(new TimesVerify(classMethod, 0, max));
    }

    public static void between(String classMethod, int min, int max) {
        TimesVerify.add(new TimesVerify(classMethod, min, max));
    }

    public static void just(String classMethod, int times) {
        TimesVerify.add(new TimesVerify(classMethod, times, times));
    }

    public static void increaseTimes(MethodId methodId) {
        if (invokedTimes.get() == null) {
            return;
        }
        String classMethod = methodId.realClassDesc + "#" + methodId.name + methodId.descNoInvocation;
        if (classMethod.startsWith("org/junit/runner") || classMethod.startsWith("org/test4j/integration")) {
            return;
        }
        int index = classMethod.indexOf(41);
        classMethod = classMethod.substring(0, index + 1);
        Integer times = invokedTimes.get().get(classMethod);
        times = times == null ? 1 : times + 1;
        invokedTimes.get().put(classMethod, times);
    }

    public static void initVerify() {
        if (timesVerifier.get() == null) {
            timesVerifier.set(new ArrayList());
        }
        if (invokedTimes.get() == null) {
            invokedTimes.set(new HashMap());
        }
        timesVerifier.get().clear();
        invokedTimes.get().clear();
    }

    public static void verify() {
        if (timesVerifier.get() == null) {
            return;
        }
        for (TimesVerify verify : timesVerifier.get()) {
            verify.verifyTimes();
        }
    }

    public String getClassMethod() {
        return this.classMethod;
    }
}

