/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.modifier;

import g_asm.org.objectweb.asm.ClassVisitor;
import g_asm.org.objectweb.asm.ClassWriter;
import g_asm.org.objectweb.asm.MethodVisitor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.faking.modifier.FakeMethodModifier;
import org.test4j.mock.faking.modifier.FakeTransformer;

public class FakeClassModifier
extends ClassVisitor {
    static final int METHOD_ACCESS_MASK = 64255;
    String superClassName;
    String classDesc;
    final Map<String, Boolean> fakedMethods = new HashMap<String, Boolean>();

    public FakeClassModifier() {
        super(458752, (ClassVisitor)new ClassWriter(2));
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int modifiedVersion = (version & 0xFFFF) < 52 ? 52 : version;
        this.cv.visit(modifiedVersion, access, name, signature, superName, interfaces);
        this.superClassName = superName;
        this.classDesc = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.notMockMethod(access)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        this.fakedMethods.put(MethodId.buildMethodDesc(name, desc), Modifier.isStatic(access));
        MethodVisitor mw = super.visitMethod(access & 0xFAFF, name, desc, signature, exceptions);
        return new FakeMethodModifier(this, mw, access, name, desc);
    }

    private boolean notMockMethod(int access) {
        if ((access & 0x1500) != 0) {
            return true;
        }
        return FakeTransformer.notMockType(this.classDesc);
    }

    public byte[] toByteArray() {
        return ((ClassWriter)this.cv).toByteArray();
    }

    public Map<String, Boolean> getFakedMethods() {
        return this.fakedMethods;
    }
}

