/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.modifier;

import g_asm.org.objectweb.asm.ClassReader;
import g_asm.org.objectweb.asm.ClassVisitor;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.test4j.mock.faking.modifier.FakeClassModifier;
import org.test4j.mock.faking.util.ClassFile;
import org.test4j.mock.faking.util.TypeUtility;
import org.test4j.mock.startup.Startup;

public final class FakeTransformer
implements ClassFileTransformer {
    public static final FakeTransformer INSTANCE = new FakeTransformer();
    static final transient Map<String, Map<String, Boolean>> fakedMethods = new HashMap<String, Map<String, Boolean>>(32);
    private Class beingCached;
    private static final List<String> Not_Mock_Packages = Arrays.asList("java.lang.", "java.util.concurrent.", "java.util.jar.", "java.util.regex.", "java.util.zip.", "jdk.internal.", "sun.", "com.sun.");

    private FakeTransformer() {
    }

    public static Boolean findMethodInFaked(String classDesc, String methodDesc) {
        Map<String, Boolean> map = fakedMethods.get(classDesc);
        return map == null ? null : map.get(methodDesc);
    }

    public byte[] transform(ClassLoader loader, String classDesc, Class aClass, ProtectionDomain domain, byte[] bytes) {
        byte[] faked = null;
        if (this.beenCaching(classDesc, aClass)) {
            faked = FakeTransformer.fake(classDesc, aClass, bytes);
            this.beingCached = null;
        }
        return faked;
    }

    private boolean beenCaching(String classDesc, Class beingRedefined) {
        if (classDesc == null) {
            return false;
        }
        if (fakedMethods.containsKey(classDesc)) {
            return false;
        }
        return beingRedefined != null && beingRedefined == this.beingCached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] fake(String classDesc, Class classToFake, byte[] bytes) {
        if (fakedMethods.containsKey(classDesc)) {
            return bytes;
        }
        FakeTransformer fakeTransformer = INSTANCE;
        synchronized (fakeTransformer) {
            if (fakedMethods.containsKey(classDesc) || FakeTransformer.notMockType(classDesc)) {
                return bytes;
            }
            FakeClassModifier cv = new FakeClassModifier();
            new ClassReader(bytes).accept((ClassVisitor)cv, 8);
            byte[] faked = cv.toByteArray();
            ClassFile.writeBytes4Debug(classToFake.getName(), faked);
            fakedMethods.put(classDesc, cv.getFakedMethods());
            return faked;
        }
    }

    public static boolean notMockType(String typeName) {
        String name = typeName.replace('/', '.');
        for (String prefix : Not_Mock_Packages) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static void applyFakes(Class declaredToFake) {
        if (declaredToFake == null) {
            return;
        }
        Set<Class> toBeFakes = TypeUtility.findAllClass(declaredToFake);
        for (Class classToModify : toBeFakes) {
            FakeTransformer.fakeClass(classToModify);
        }
    }

    private static void fakeClass(Class aClass) {
        String classDesc = TypeUtility.classPath(aClass);
        if (fakedMethods.containsKey(classDesc)) {
            return;
        }
        FakeTransformer.INSTANCE.beingCached = aClass;
        Startup.reTransformClass(aClass);
    }
}

