/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class ObjectIdentify {
    public static Integer[] identities(Object[] objects) {
        if (objects == null) {
            return new Integer[]{0};
        }
        if (objects.length == 0) {
            return new Integer[0];
        }
        if (objects.length == 1) {
            if (objects[0] instanceof Collection) {
                return ObjectIdentify.identities((Collection)objects[0]);
            }
            return new Integer[]{ObjectIdentify.identityObj(objects[0])};
        }
        return Arrays.stream(objects).map(ObjectIdentify::identityObj).collect(Collectors.toList()).toArray(new Integer[0]);
    }

    private static Integer[] identities(Collection objects) {
        if (objects.size() == 0) {
            return new Integer[]{-1};
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object obj : objects) {
            if (obj instanceof Integer) {
                list.add((Integer)obj);
                continue;
            }
            list.add(System.identityHashCode(obj));
        }
        return list.toArray(new Integer[0]);
    }

    public static Integer[] identity(Class declaredClass, Collection list) {
        ArrayList<Integer> hashCodes = new ArrayList<Integer>();
        if (list != null) {
            if (declaredClass.isAssignableFrom(list.getClass())) {
                hashCodes.add(System.identityHashCode(list));
            } else {
                list.stream().map(ObjectIdentify::identityObj).forEach(i -> hashCodes.add((Integer)i));
            }
        }
        return hashCodes.toArray(new Integer[0]);
    }

    public static Class getObjectClass(Object[] objects) {
        if (objects == null || objects.length == 0 || objects[0] == null) {
            throw new RuntimeException("the object can't be null.");
        }
        if (objects.length == 1 && objects[0] instanceof Collection) {
            return ObjectIdentify.getObjectClass((Collection)objects[0]);
        }
        return objects[0].getClass();
    }

    public static Class getObjectClass(Collection objects) {
        if (objects == null || objects.size() == 0) {
            throw new RuntimeException("the object can't be null.");
        }
        Object first = objects.iterator().next();
        if (first == null) {
            throw new RuntimeException("the object can't be null.");
        }
        return first.getClass();
    }

    private static Integer identityObj(Object target) {
        if (target instanceof Integer) {
            return (Integer)target;
        }
        return System.identityHashCode(target);
    }
}

