/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.util;

import java.util.ArrayList;
import java.util.List;
import org.test4j.mock.faking.util.ClassLoad;

class SearchingClassLoader
extends ClassLoader {
    public static final ClassLoader THIS_CL = ClassLoad.class.getClassLoader();
    private final ClassLoader nextToSearch;

    private SearchingClassLoader(ClassLoader parent, ClassLoader nextToSearch) {
        super(parent);
        this.nextToSearch = nextToSearch;
    }

    private static ClassLoader combine(List<ClassLoader> parents) {
        ClassLoader loader = parents.get(parents.size() - 1);
        for (int i = parents.size() - 2; i >= 0; --i) {
            loader = new SearchingClassLoader(parents.get(i), loader);
        }
        return loader;
    }

    static ClassLoader combineLoadersOf(Class first, Class ... types) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        SearchingClassLoader.addIfNewElement(loaders, first == null ? null : first.getClassLoader());
        for (Class type : types) {
            SearchingClassLoader.addIfNewElement(loaders, type == null ? null : type.getClassLoader());
        }
        SearchingClassLoader.addIfNewElement(loaders, THIS_CL);
        SearchingClassLoader.addIfNewElement(loaders, Thread.currentThread().getContextClassLoader());
        SearchingClassLoader.addIfNewElement(loaders, ClassLoader.getSystemClassLoader());
        return SearchingClassLoader.combine(loaders);
    }

    private static void addIfNewElement(List<ClassLoader> loaders, ClassLoader c) {
        if (c != null && !loaders.contains(c)) {
            loaders.add(c);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.nextToSearch != null) {
            return this.nextToSearch.loadClass(name);
        }
        return super.findClass(name);
    }
}

