/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor;

import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.test4j.annotations.Beans;
import org.test4j.mock.processor.BaseProcessor;
import org.test4j.mock.processor.filer.BeanRegisterFiler;
import org.test4j.mock.processor.filer.attr.BeanAttribute;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"org.test4j.annotations.Beans"})
@AutoService(value={Processor.class})
public class BeansProcessor
extends BaseProcessor<Beans> {
    private static final String ATTR_BEANS = "beans()";
    private static final String ATTR_NAMES = "names()";

    @Override
    protected Class<Beans> getAnnotationClass() {
        return Beans.class;
    }

    @Override
    protected void doProcessor(Element element, Beans annotation) {
        String fullName = ((TypeElement)element).getQualifiedName().toString();
        BeanAttribute attribute = new BeanAttribute(Beans.class, (TypeElement)element);
        Set<String> beans = attribute.getClasses(ATTR_BEANS);
        Map<String, String> names = attribute.getNames(ATTR_NAMES);
        if (beans.isEmpty() && names.isEmpty()) {
            return;
        }
        new BeanRegisterFiler(fullName, annotation.suffixBeanRegister(), beans, names).writeFiler();
    }
}

