/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.test4j.mock.faking.fluent.MocksApply;
import org.test4j.mock.processor.MocksProcessor;
import org.test4j.mock.processor.filer.attr.ClassNames;
import org.test4j.mock.processor.filer.file.MockClassFiler;
import org.test4j.mock.processor.filer.file.MockTypeFiler;
import org.test4j.mock.processor.filer.file.MockUpFiler;

public class MocksFiler {
    private static Set<String> Has_Mocks = new ConcurrentSkipListSet<String>();
    private ClassName fullName;
    private String suffix;
    private Map<String, ClassName> mocks = new HashMap<String, ClassName>();
    private static final String Mock1_JavaDoc = " mock {@link $T} \u591a\u4e2a\u65b9\u6cd5, \u793a\u4f8b\u4ee3\u7801\n <pre>\n mocks.$L(fake->{\n      fake.toMockMethod1.restReturn(\"\u8fd4\u56de\u503c1\",\"\u8fd4\u56de\u503c2\");\n      fake.toMockMethod2.restReturn(\"\u8fd4\u56de\u503c1\",\"\u8fd4\u56de\u503c2\");\n });\n </pre>\n\n @param faker   {@link $LMockUp} \u6784\u9020\n @param targets \u6307\u5b9a, \u8868\u793a\u5bf9\u7279\u5b9a$L\u5b9e\u4f8b\u8fdb\u884cmock;\u5426\u5219,\u8868\u793a\u5bf9\u6240\u6709$L\u5b9e\u4f8b\u8fdb\u884cmock";
    private static final String Mock2_JavaDoc = " mock {@link $T} \u5355\u4e2a\u65b9\u6cd5, \u793a\u4f8b\u4ee3\u7801\n <pre>\n mocks.$L().toMockMethod1.restReturn(\"\u8fd4\u56de\u503c1\",\"\u8fd4\u56de\u503c2\");\n </pre>\n\n @param targets \u6307\u5b9a, \u8868\u793a\u5bf9\u7279\u5b9a$L\u5b9e\u4f8b\u8fdb\u884cmock;\u5426\u5219,\u8868\u793a\u5bf9\u6240\u6709$L\u5b9e\u4f8b\u8fdb\u884cmock";

    public MocksFiler(String fullName, String suffix, Set<String> mocks) {
        this.fullName = ClassNames.getClassName(fullName);
        this.suffix = suffix;
        this.addToMockClass(mocks);
    }

    private void addToMockClass(Collection<String> mocks) {
        for (String mock : mocks) {
            this.addMockFile(mock);
        }
    }

    private void addMockFile(String mock) {
        if (mock == null || mock.isEmpty()) {
            return;
        }
        ClassName mockClassName = ClassNames.getClassName("mock." + mock + "MockUp");
        this.mocks.put(mock, mockClassName);
    }

    public void writeFiler() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(this.fullName.simpleName() + this.suffix)).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(MocksApply.class);
        this.build(builder);
        builder.addField(this.m_mocksField(this.fullName.simpleName() + this.suffix));
        JavaFile.Builder javaBuilder = JavaFile.builder((String)this.fullName.packageName(), (TypeSpec)builder.build());
        MocksProcessor.writeFiler(javaBuilder.build());
    }

    private void build(TypeSpec.Builder builder) {
        for (Map.Entry<String, ClassName> entry : this.mocks.entrySet()) {
            builder.addMethod(this.m_mockUp1(entry.getKey(), entry.getValue()));
            builder.addMethod(this.m_mockUp2(entry.getKey(), entry.getValue()));
            builder.addField(this.m_mockUpField(entry.getKey(), entry.getValue()));
        }
        while (!this.mocks.isEmpty()) {
            Map.Entry<String, ClassName> entry;
            Iterator<Map.Entry<String, ClassName>> it = this.mocks.entrySet().iterator();
            entry = it.next();
            it.remove();
            MockUpFiler mockUpFiler = this.generateMockUp(entry.getKey());
            if (mockUpFiler == null) continue;
            mockUpFiler.writeFiler();
            this.addMockFile(mockUpFiler.getSuperClass());
        }
    }

    private MethodSpec m_mockUp1(String toFaked, ClassName mockUp) {
        ClassName name = ClassNames.getClassName(toFaked);
        return MethodSpec.methodBuilder((String)name.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc(Mock1_JavaDoc, new Object[]{name, name.simpleName(), name.simpleName(), name.simpleName(), name.simpleName()}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{mockUp}), "faker", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of(Object.class), "targets", new Modifier[0]).varargs(true).returns((TypeName)TypeVariableName.get((String)(this.fullName.simpleName() + this.suffix))).addStatement("return super.apply(faker, new $T(targets))", new Object[]{mockUp}).build();
    }

    private MethodSpec m_mockUp2(String toFaked, ClassName mockUp) {
        ClassName name = ClassNames.getClassName(toFaked);
        return MethodSpec.methodBuilder((String)name.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc(Mock2_JavaDoc, new Object[]{name, name.simpleName(), name.simpleName(), name.simpleName()}).addParameter((TypeName)ArrayTypeName.of(Object.class), "targets", new Modifier[0]).varargs(true).returns((TypeName)mockUp).addStatement("return new $T(targets)", new Object[]{mockUp}).build();
    }

    private FieldSpec m_mockUpField(String toFaked, ClassName mockUp) {
        ClassName name = ClassNames.getClassName(toFaked);
        return FieldSpec.builder((TypeName)mockUp, (String)name.simpleName(), (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addJavadoc("@see #$L(Object...), \u65e0\u53c2\u6a21\u5f0f ", new Object[]{name.simpleName()}).initializer("$L()", new Object[]{name.simpleName()}).build();
    }

    private FieldSpec m_mocksField(String mocksClass) {
        return FieldSpec.builder((TypeName)ClassNames.getClassName(mocksClass), (String)"mocks", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("$L\u5168\u5c40\u53d8\u91cf, \u65b9\u4fbf\u5f15\u7528", new Object[]{mocksClass}).initializer("new $L()", new Object[]{mocksClass}).build();
    }

    private MockUpFiler generateMockUp(String className) {
        if (Has_Mocks.contains(className)) {
            return null;
        }
        Has_Mocks.add(className);
        try {
            return new MockClassFiler(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            TypeElement typeElement = MocksProcessor.getTypeElement(className);
            if (typeElement != null) {
                return new MockTypeFiler(typeElement);
            }
            MocksProcessor.error("ClassNotFoundException", e);
            return null;
        }
    }
}

