/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.test4j.integration.spring.BeanRegister;
import org.test4j.mock.processor.MocksProcessor;
import org.test4j.mock.processor.filer.attr.ClassNames;

public class StubRegisterFiler {
    private final ClassName fullName;
    private final String suffix;
    private final List<String> stubs;
    private final Map<String, String> names;

    public StubRegisterFiler(String fullName, String suffix, Collection<String> stubs, Map<String, String> names) {
        this.fullName = ClassNames.getClassName(fullName);
        this.suffix = suffix;
        this.stubs = new ArrayList<String>(stubs);
        this.names = names;
    }

    public void writeFiler() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(this.fullName.simpleName() + this.suffix)).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(BeanRegister.class).addMethod(this.m_constructor());
        JavaFile.Builder javaBuilder = JavaFile.builder((String)this.fullName.packageName(), (TypeSpec)builder.build());
        MocksProcessor.writeFiler(javaBuilder.build());
    }

    private MethodSpec m_constructor() {
        ClassName className;
        MethodSpec.Builder spec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (String string : this.stubs) {
            className = ClassNames.getClassName(string);
            spec.addStatement("this.stub($T.class)", new Object[]{className});
        }
        for (Map.Entry entry : this.names.entrySet()) {
            className = ClassNames.getClassName((String)entry.getValue());
            spec.addStatement("this.stub($L, $T.class)", new Object[]{entry.getKey(), className});
        }
        return spec.build();
    }
}

