/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer.attr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class BeanAttribute {
    private Class aClass;
    private TypeElement element;

    public BeanAttribute(Class aClass, TypeElement element) {
        this.aClass = aClass;
        this.element = element;
    }

    public Set<String> getClasses(String attribute) {
        AnnotationMirror mirror = this.getMocksMirror(this.element);
        HashSet<String> values = new HashSet<String>();
        if (mirror == null) {
            return values;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement method = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!method.toString().contains(attribute)) continue;
            List list = (List)value.getValue();
            for (AnnotationValue item : list) {
                values.add(item.getValue().toString());
            }
            return values;
        }
        return values;
    }

    public Map<String, String> getNames(String attribute) {
        AnnotationMirror mirror = this.getMocksMirror(this.element);
        HashMap<String, String> values = new HashMap<String, String>();
        if (mirror == null) {
            return values;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement method = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!method.toString().contains(attribute)) continue;
            List list = (List)value.getValue();
            for (AnnotationMirror item : list) {
                String name = null;
                String klass = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attr : item.getElementValues().entrySet()) {
                    String keyName = attr.getKey().toString();
                    if ("name()".equals(keyName)) {
                        name = attr.getValue().toString();
                        continue;
                    }
                    if (!"value()".equals(keyName) || !(klass = attr.getValue().toString()).endsWith(".class")) continue;
                    klass = klass.substring(0, klass.length() - 6);
                }
                if (name == null || name.trim().isEmpty() || klass == null || klass.trim().isEmpty()) continue;
                values.put(name, klass);
            }
            return values;
        }
        return values;
    }

    private AnnotationMirror getMocksMirror(TypeElement element) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().toString().contains(this.aClass.getSimpleName())) continue;
            return annotationMirror;
        }
        return null;
    }
}

