/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer.attr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.test4j.mock.faking.util.TypeDesc;
import org.test4j.mock.faking.util.TypeUtility;

public class ExecutableHelper {
    public static int getAccess(ExecutableElement executable) {
        Set<Modifier> modifiers = executable.getModifiers();
        int access = 0;
        for (Modifier modifier : modifiers) {
            String value = modifier.name();
            if ("ABSTRACT".equals(value)) {
                access += 1024;
                continue;
            }
            if ("NATIVE".equals(value)) {
                access += 256;
                continue;
            }
            if (!"STATIC".equals(value)) continue;
            access += 8;
        }
        return access;
    }

    public static String getParaDesc(ExecutableElement executable, Map<String, String> classVars) {
        StringBuilder buff = new StringBuilder("(");
        Map<String, String> varMaps = ExecutableHelper.getVarDesc(executable.getTypeParameters(), new HashMap<String, String>(classVars));
        List<? extends VariableElement> paras = executable.getParameters();
        for (VariableElement variableElement : paras) {
            buff.append(TypeUtility.descriptor(variableElement.asType().toString(), varMaps));
        }
        TypeMirror returnType = executable.getReturnType();
        buff.append(")").append(TypeUtility.descriptor(returnType.toString(), varMaps));
        return buff.toString();
    }

    public static Map<String, String> getVarDesc(List<? extends TypeParameterElement> varTypes, Map<String, String> varMaps) {
        for (TypeParameterElement typeParameterElement : varTypes) {
            String varName = typeParameterElement.getSimpleName().toString();
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            if (bounds == null || bounds.isEmpty()) {
                varMaps.put(varName, TypeDesc.T_Object.DESC);
                continue;
            }
            varMaps.put(varName, TypeUtility.descriptor(bounds.get(0).toString(), varMaps));
        }
        return varMaps;
    }
}

