/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer.file;

import com.squareup.javapoet.ClassName;
import g_asm.org.objectweb.asm.ClassReader;
import g_asm.org.objectweb.asm.ClassVisitor;
import g_asm.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.util.List;
import org.test4j.mock.faking.modifier.FakeTransformer;
import org.test4j.mock.faking.util.ClassFile;
import org.test4j.mock.faking.util.TypeUtility;
import org.test4j.mock.processor.filer.attr.MockUpParseMethodVisitor;
import org.test4j.mock.processor.filer.file.MockUpFiler;

public class MockClassFiler
extends MockUpFiler {
    private Class clazz;

    public MockClassFiler(Class clazz) {
        super(ClassName.get((Class)clazz));
        this.clazz = clazz;
        this.parserSuperClass();
        this.parseMethodIds();
        this.parseAbstractMethodIds();
    }

    @Override
    protected void parseMethodIds() {
        ClassReader cr = ClassFile.getClassReader(this.clazz);
        cr.accept((ClassVisitor)new MockUpParseMethodVisitor(this), 8);
    }

    private void parseAbstractMethodIds() {
        List<Method> interfaceMethods = TypeUtility.findInterfaceMethod(this.clazz);
        for (Method method : interfaceMethods) {
            super.addMethodId(method.getModifiers(), method.getName(), Type.getMethodDescriptor((Method)method));
        }
    }

    @Override
    protected void parserSuperClass() {
        Class superClass = this.clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        String fullName = this.clazz.getSuperclass().getName();
        if (!FakeTransformer.notMockType(fullName)) {
            this.superClass = fullName;
        }
    }
}

