/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer.file;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.test4j.mock.faking.fluent.FluentMockUp;
import org.test4j.mock.faking.fluent.MethodBehaviors;
import org.test4j.mock.faking.fluent.MockMethodWithTimes;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.faking.util.TypeUtility;
import org.test4j.mock.processor.MocksProcessor;
import org.test4j.mock.processor.filer.attr.ClassNames;

public abstract class MockUpFiler {
    private static final String SUFFIX_SUPER = "$";
    protected ClassName className;
    protected List<MethodId> declaredMethodIds = new ArrayList<MethodId>();
    protected List<MethodId> abstractMethodIds = new ArrayList<MethodId>();
    private Set<String> existNames = new HashSet<String>();
    private Set<String> sameNames = new HashSet<String>();
    private String classDesc;
    protected String superClass;

    public MockUpFiler(ClassName className) {
        this.className = className;
        this.classDesc = TypeUtility.classPath(className.reflectionName());
    }

    protected abstract void parserSuperClass();

    protected abstract void parseMethodIds();

    public MethodId addMethodId(int access, String name, String descriptor) {
        if (Objects.equals("<clinit>", name) || Modifier.isNative(access)) {
            return null;
        }
        MethodId methodId = new MethodId(this.classDesc, this.superClass, name, descriptor);
        if (this.declaredMethodIds.contains(methodId) || this.abstractMethodIds.contains(methodId)) {
            return null;
        }
        if (Modifier.isAbstract(access)) {
            this.abstractMethodIds.add(methodId);
        } else {
            this.declaredMethodIds.add(methodId);
        }
        if (this.existNames.contains(name)) {
            this.sameNames.add(name);
        } else {
            this.existNames.add(name);
        }
        return methodId;
    }

    public void writeFiler() {
        String fullName = "mock." + this.fullName(this.className) + "MockUp";
        ClassName mockUp = ClassNames.getClassName(fullName);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)mockUp.simpleName()).superclass((TypeName)ClassName.get(FluentMockUp.class)).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
        this.build(builder);
        JavaFile.Builder javaBuilder = JavaFile.builder((String)mockUp.packageName(), (TypeSpec)builder.build());
        MocksProcessor.writeFiler(javaBuilder.build());
    }

    private String fullName(ClassName className) {
        if (className.enclosingClassName() == null) {
            String pack = className.packageName();
            return pack.isEmpty() ? className.simpleName() : pack + "." + className.simpleName();
        }
        return this.fullName(className.enclosingClassName()) + "." + className.simpleName();
    }

    private void build(TypeSpec.Builder builder) {
        builder.addMethod(this.m_constructor1());
        builder.addMethod(this.m_constructor3());
        for (MethodId meta : this.declaredMethodIds) {
            builder.addField(this.f_method(meta, false));
        }
        for (MethodId meta : this.abstractMethodIds) {
            builder.addField(this.f_method(meta, true));
        }
        if (this.superClass != null) {
            builder.addField(this.f_superMock("super$", this.superClass));
        }
    }

    private MethodSpec m_constructor3() {
        return MethodSpec.constructorBuilder().addParameter(Class.class, "declaredClass", new javax.lang.model.element.Modifier[0]).addParameter(MethodBehaviors.class, "behaviors", new javax.lang.model.element.Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(Set.class, (Type[])new Type[]{Integer.class}), "fakedHashCodes", new javax.lang.model.element.Modifier[0]).addStatement("super(declaredClass, behaviors, fakedHashCodes)", new Object[0]).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).build();
    }

    private MethodSpec m_constructor1() {
        return MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addParameter((TypeName)ArrayTypeName.of(Object.class), "targets", new javax.lang.model.element.Modifier[0]).varargs(true).addStatement("super($S, targets)", new Object[]{this.className.reflectionName()}).build();
    }

    private FieldSpec f_superMock(String name, String clazz) {
        ClassName type = ClassNames.getClassName("mock." + clazz + "MockUp");
        return FieldSpec.builder((TypeName)type, (String)name, (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL}).initializer("new $T(this.declaredToFake, this.behaviors, super.fakedHashCodes)", new Object[]{type}).build();
    }

    private FieldSpec f_method(MethodId meta, boolean isAbstract) {
        String fieldName = this.buildMethodMockField(meta.name, meta.getParams());
        if (isAbstract) {
            fieldName = fieldName + SUFFIX_SUPER;
        }
        TypeName rType = ClassNames.getReturnType(meta.getReturnType().getClassName());
        ParameterizedTypeName type = ParameterizedTypeName.get((ClassName)ClassName.get(MockMethodWithTimes.class), (TypeName[])new TypeName[]{rType});
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)type, (String)fieldName, (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL}).initializer("new MockMethodWithTimes<>(this, $S, $S, $S)", new Object[]{isAbstract ? null : meta.realClassDesc, meta.name, meta.desc}).addJavadoc("mock {@link $T#$L}", new Object[]{this.className, this.linkJavaDoc(meta)});
        Map<Integer, MethodId.ParaNameType> params = meta.getParameters();
        if (params == null) {
            return builder.build();
        }
        builder.addJavadoc(", example code:", new Object[0]).addJavadoc("\n<pre>\n", new Object[0]).addJavadoc("mocks.$L.$L.restAnswer(inv -> {", new Object[]{this.className.simpleName(), fieldName});
        for (int index = 0; index < params.size(); ++index) {
            if (!params.containsKey(index)) continue;
            String pName = params.get((Object)Integer.valueOf((int)index)).name;
            String pType = this.getSimpleName(params.get(index));
            builder.addJavadoc("\n\t$L $L = inv.arg($L);", new Object[]{pType, pName, index});
        }
        builder.addJavadoc("\n\treturn null; //TODO", new Object[0]).addJavadoc("\n});", new Object[0]).addJavadoc("\n</pre>", new Object[0]);
        return builder.build();
    }

    private String getSimpleName(MethodId.ParaNameType nameType) {
        String pType = g_asm.org.objectweb.asm.Type.getType((String)nameType.type).getClassName();
        int index = pType.lastIndexOf(46);
        return index >= 0 ? pType.substring(index + 1) : pType;
    }

    private String linkJavaDoc(MethodId meta) {
        StringBuffer buff = new StringBuffer();
        String name = meta.name;
        buff.append("<init>".equals(name) ? this.className.simpleName() : name).append("(");
        String paras = Stream.of(meta.getParams()).map(g_asm.org.objectweb.asm.Type::getClassName).collect(Collectors.joining(", "));
        buff.append(paras);
        return buff.append(")").toString();
    }

    private String buildMethodMockField(String name, g_asm.org.objectweb.asm.Type[] params) {
        StringBuffer buff = new StringBuffer();
        if (Objects.equals("<init>", name)) {
            buff.append("$init");
        } else {
            buff.append(name);
        }
        if (!this.sameNames.contains(name)) {
            return buff.toString();
        }
        for (g_asm.org.objectweb.asm.Type para : params) {
            String clazzName = TypeUtility.getShortClassName(para.getClassName());
            int index = clazzName.indexOf("[]");
            if (index > 0) {
                int size = (clazzName.length() - index) / 2;
                clazzName = clazzName.substring(0, index) + "D" + size;
            }
            buff.append("_").append(clazzName);
        }
        return buff.toString();
    }

    public String getSuperClass() {
        return this.superClass;
    }
}

