/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.props;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.test4j.Logger;
import org.test4j.mock.Stubs;

public class FakeProperties {
    private Object target;
    private Class klass;

    public FakeProperties(Object target) {
        if (target == null) {
            throw new RuntimeException("The target object can't be null.");
        }
        this.target = target;
        this.klass = target.getClass();
    }

    public Map<String, Object> fakeNullProperties() {
        return this.fakeProperties(f -> f.get(this.target) == null);
    }

    public Map<String, Object> fakeNullByAnnotation(Class<? extends Annotation> ... annotationClass) {
        return this.fakeProperties(f -> {
            if (f.get(this.target) != null) {
                return false;
            }
            for (Class aClass : annotationClass) {
                if (f.getAnnotation(aClass) == null) continue;
                return true;
            }
            return false;
        });
    }

    private Map<String, Object> fakeProperties(FieldPredicate predicate) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Class aClass = this.klass; aClass != Object.class; aClass = aClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = aClass.getDeclaredFields()) {
                Object obj;
                String fn = field.getName();
                Class<?> ft = field.getType();
                String ftn = ft.getName();
                if (fn.contains("$") || ft.isArray() || Enum.class.isAssignableFrom(ft) || Annotation.class.isAssignableFrom(ft) || ftn.startsWith("java.") || ftn.startsWith("sun.") || (obj = this.fakeField(field, predicate)) == null || aClass.isInterface()) continue;
                properties.put(aClass.getName().replace('$', '_') + "#" + field.getName(), obj);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fakeField(Field field, FieldPredicate predicate) {
        boolean accessible = field.isAccessible();
        try {
            Object obj;
            field.setAccessible(true);
            if (!predicate.test(field)) {
                Object var4_4 = null;
                return var4_4;
            }
            Class<?> aClass = field.getType();
            if (aClass.isPrimitive()) {
                Object var5_7 = null;
                return var5_7;
            }
            if (Modifier.isFinal(aClass.getModifiers())) {
                Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                obj = constructor.newInstance(new Object[0]);
            } else {
                obj = Stubs.fake(field.getType());
            }
            if (obj != null) {
                field.set(this.target, obj);
            }
            Object obj2 = obj;
            return obj2;
        }
        catch (Exception e) {
            Logger.warn("fakeField[" + field.getType().getName() + "#" + field.getName() + "] error: " + e.getMessage(), new Throwable[0]);
        }
        finally {
            field.setAccessible(accessible);
        }
        return null;
    }

    private static interface FieldPredicate {
        public boolean test(Field var1) throws Exception;
    }
}

