/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.startup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.test4j.mock.MockUp;
import org.test4j.mock.faking.util.ClassFile;
import org.test4j.mock.faking.util.ClassLoad;
import org.test4j.mock.faking.util.ReflectUtility;
import org.test4j.mock.faking.util.StackTrace;
import org.test4j.mock.startup.IStartupMock;

final class MockInitialization {
    private MockInitialization() {
    }

    static void initialize() {
        ClassFile.initPrintFakes();
        MockInitialization.applyStartupSpiFakesAsNeeded();
        MockInitialization.applyUserSpecifiedStartupFakesIfAny();
    }

    private static void applyStartupSpiFakesAsNeeded() {
        ServiceLoader<IStartupMock> loader = ServiceLoader.load(IStartupMock.class);
        for (IStartupMock startupMock : loader) {
            startupMock.initial();
        }
    }

    private static void applyUserSpecifiedStartupFakesIfAny() {
        Collection<String> fakeClasses = MockInitialization.getFakeClasses();
        for (String fakeClassName : fakeClasses) {
            MockInitialization.applyStartupFake(fakeClassName);
        }
    }

    private static Collection<String> getFakeClasses() {
        String commaOrSpaceSeparatedValues = System.getProperty("fakes");
        if (commaOrSpaceSeparatedValues == null) {
            return Collections.emptyList();
        }
        String[] fakeClassNames = commaOrSpaceSeparatedValues.split("\\s*,\\s*|\\s+");
        HashSet<String> uniqueClassNames = new HashSet<String>(Arrays.asList(fakeClassNames));
        uniqueClassNames.remove("");
        return uniqueClassNames;
    }

    private static void applyStartupFake(String fakeClassName) {
        String argument = null;
        int p = fakeClassName.indexOf(61);
        if (p > 0) {
            argument = fakeClassName.substring(p + 1);
            fakeClassName = fakeClassName.substring(0, p);
        }
        try {
            Class fakeClass = ClassLoad.loadClass(fakeClassName);
            if (MockUp.class.isAssignableFrom(fakeClass)) {
                ReflectUtility.newInstance(fakeClass, argument);
            }
        }
        catch (UnsupportedOperationException fakeClass) {
        }
        catch (Throwable unexpectedFailure) {
            StackTrace.filterStackTrace(unexpectedFailure);
            unexpectedFailure.printStackTrace();
        }
    }
}

