/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.stub;

import g_cglib.net.sf.cglib.core.CodeGenerationException;
import g_cglib.net.sf.cglib.core.DefaultNamingPolicy;
import g_cglib.net.sf.cglib.core.NamingPolicy;
import g_cglib.net.sf.cglib.core.Predicate;
import g_cglib.net.sf.cglib.proxy.Callback;
import g_cglib.net.sf.cglib.proxy.Enhancer;
import g_cglib.net.sf.cglib.proxy.Factory;
import g_cglib.net.sf.cglib.proxy.InvocationHandler;
import g_cglib.net.sf.cglib.proxy.MethodInterceptor;
import g_cglib.net.sf.cglib.proxy.NoOp;
import g_objenesis.org.objenesis.Objenesis;
import g_objenesis.org.objenesis.ObjenesisStd;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.test4j.mock.faking.util.ClassLoad;
import org.test4j.mock.faking.util.TypeUtility;
import org.test4j.mock.stub.FakeInterceptor;
import org.test4j.mock.stub.IFakeStub;
import org.test4j.mock.stub.ObjectStub;
import org.test4j.mock.stub.ProxyInvocation;
import org.test4j.mock.stub.ProxyInvokable;

public class Impostor {
    private static final NamingPolicy NAMING_POLICY = new DefaultNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "org.test4j.stub." + super.getClassName(prefix, source, key, names);
        }
    };
    private static final Objenesis objenesis = new ObjenesisStd();

    private Impostor() {
    }

    static Class createStubClass(boolean isStub, Class baseType, Class ... interfaces) {
        if (baseType == Object.class) {
            baseType = ObjectStub.class;
        }
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class sc, List constructors) {
            }
        };
        enhancer.setUseCache(false);
        enhancer.setClassLoader(ClassLoad.loadersOf(baseType, interfaces));
        enhancer.setUseFactory(true);
        if (baseType.isInterface()) {
            enhancer.setSuperclass(ObjectStub.class);
            enhancer.setInterfaces(Impostor.toArray(baseType, interfaces));
        } else {
            enhancer.setSuperclass(baseType);
            enhancer.setInterfaces(interfaces);
        }
        if (isStub) {
            enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
            enhancer.setCallbackFilter(method -> Modifier.isAbstract(method.getModifiers()) ? 0 : 1);
        } else {
            enhancer.setCallbackTypes(new Class[]{InvocationHandler.class, NoOp.class});
            enhancer.setCallbackFilter(method -> method.isBridge() ? 1 : 0);
        }
        if (baseType.getSigners() != null) {
            enhancer.setNamingPolicy(NAMING_POLICY);
        }
        try {
            return enhancer.createClass();
        }
        catch (CodeGenerationException e) {
            throw new IllegalArgumentException("could not proxy " + baseType, e);
        }
    }

    public static <T> T proxy(ProxyInvokable invokable, Class baseType, Class ... interfaces) {
        return Impostor.enhancer((Callback)((InvocationHandler)(receiver, method, args) -> invokable.invoke(new ProxyInvocation(receiver, method, args))), null, baseType, interfaces);
    }

    public static <T> T fake(Class baseType, Object ... args) {
        return Impostor.stub(new FakeInterceptor(baseType), args, baseType, IFakeStub.class);
    }

    public static <T> T stub(MethodInterceptor interceptor, Object[] args, Class baseType, Class ... interfaces) {
        return Impostor.enhancer((Callback)interceptor, args == null ? new Object[]{} : args, baseType, interfaces);
    }

    static <T> T enhancer(Callback callback, Object[] args, Class baseType, Class ... interfaces) {
        if (baseType.isPrimitive()) {
            throw new IllegalArgumentException(baseType.getName() + " is primitive then it can't be proxied.");
        }
        if (Modifier.isFinal(baseType.getModifiers())) {
            throw new IllegalArgumentException(baseType.getName() + " is final type then it can't be proxied.");
        }
        Impostor.setConstructorsAccessible(baseType, true);
        Class proxyClass = Impostor.createStubClass(args != null, baseType, interfaces);
        Factory factory = args == null || args.length == 0 || baseType.isInterface() ? (Factory)objenesis.newInstance(proxyClass) : Impostor.newInstance(proxyClass, baseType, args);
        factory.setCallbacks(new Callback[]{callback, NoOp.INSTANCE});
        return baseType.cast(factory);
    }

    private static Factory newInstance(Class proxyClass, Class baseType, Object[] args) {
        Constructor[] constructors = proxyClass.getDeclaredConstructors();
        Constructor constructor = Impostor.findMatchConstructor(constructors, args);
        if (constructor == null) {
            throw new RuntimeException("not found constructor for args:" + Impostor.describe(args));
        }
        try {
            return (Factory)constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("New instance[" + baseType.getName() + "] for args:" + Impostor.describe(args) + " error.", e);
        }
    }

    private static Class[] toArray(Class first, Class ... rest) {
        Class[] all = new Class[rest.length + 1];
        all[0] = first;
        System.arraycopy(rest, 0, all, 1, rest.length);
        return all;
    }

    private static void setConstructorsAccessible(Class mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    public static boolean canProxy(Class type) {
        return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers());
    }

    public static Constructor findMatchConstructor(Constructor[] constructors, Object[] args) {
        for (Constructor constructor : constructors) {
            int count = constructor.getParameterCount();
            if (count != args.length) continue;
            Class<?>[] types = constructor.getParameterTypes();
            Constructor matched = constructor;
            for (int index = 0; index < count; ++index) {
                Class<?> aType;
                Class<?> pType;
                if (args[index] == null || TypeUtility.isAssignable(pType = types[index], aType = args[index].getClass())) continue;
                matched = null;
                break;
            }
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    public static String describe(Object[] args) {
        if (args == null) {
            return null;
        }
        return Arrays.stream(args).map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
    }
}

