/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.inject.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.test4j.Context;
import org.test4j.mock.Stubs;
import org.test4j.mock.stub.ProxyInvocation;
import org.test4j.mock.stub.ProxyInvokable;
import org.test4j.module.inject.proxy.InjectHelper;

public class FieldProxy
implements ProxyInvokable {
    private final String fieldName;
    private final Field accessor;

    public FieldProxy(Class target, String fieldName) {
        this.fieldName = fieldName;
        this.accessor = InjectHelper.getField(target, fieldName);
        this.accessor.setAccessible(true);
    }

    @Override
    public Object invoke(ProxyInvocation invocation) throws Throwable {
        Object fieldValue = this.accessor.get(Context.currTestObject());
        if (fieldValue == null) {
            throw new NullPointerException(String.format("field[%s] value is null.", this.fieldName));
        }
        try {
            Method method = invocation.getMethod();
            Object[] paras = invocation.getParametersAsArray();
            boolean accessible = method.isAccessible();
            if (!accessible) {
                method.setAccessible(true);
            }
            Object o = method.invoke(fieldValue, paras);
            if (!accessible) {
                method.setAccessible(false);
            }
            return o;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                throw ((InvocationTargetException)e).getTargetException();
            }
            throw e;
        }
    }

    public static <T> T proxy(Class testClazz, Field field) {
        FieldProxy handler = new FieldProxy(testClazz, field.getName());
        Class<?> type = field.getType();
        return (T)Stubs.proxy(handler, type, new Class[0]);
    }
}

