/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.test4j.Context;
import org.test4j.annotations.BeforeSpring;
import org.test4j.mock.faking.util.ReflectUtility;
import org.test4j.module.spring.SpringInit;

public class SpringEnv {
    private static final Map<Class, Boolean> classIsSpring = new ConcurrentHashMap<Class, Boolean>();
    private static final String[] springTestAnnotations = new String[]{"org.springframework.boot.test.context.SpringBootTest", "org.springframework.test.context.ContextConfiguration", "org.test4j.integration.spring.SpringContext"};
    static Map<String, Class> HasAnnotation = new HashMap<String, Class>(5);

    public static boolean isSpringEnv() {
        return SpringEnv.isSpringEnv(Context.currTestClass());
    }

    public static void setSpringEnv(Class<?> clazz) {
        classIsSpring.put(clazz, SpringEnv.isSpringTest(clazz));
    }

    public static boolean isSpringEnv(Class clazz) {
        return clazz != null && classIsSpring.get(clazz) != null && classIsSpring.get(clazz) != false;
    }

    private static boolean isSpringTest(Class aClass) {
        if (aClass == null) {
            return false;
        }
        for (String annotation : springTestAnnotations) {
            boolean hasAnnotation = SpringEnv.hasAnnotation(aClass, annotation);
            if (!hasAnnotation) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnnotation(Class objectClass, String annotation) {
        Class<?> annotationClass = SpringEnv.getAnnotationClass(annotation);
        if (annotationClass == null) {
            return false;
        }
        Object instance = SpringEnv.getClassLevelAnnotation(annotationClass, objectClass);
        return instance != null;
    }

    private static Class<?> getAnnotationClass(String annotation) {
        if (!HasAnnotation.containsKey(annotation)) {
            try {
                Class<?> clazz = Class.forName(annotation);
                HasAnnotation.put(annotation, clazz);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                HasAnnotation.put(annotation, null);
                return null;
            }
        }
        return HasAnnotation.get(annotation);
    }

    private static <T extends Annotation> T getClassLevelAnnotation(Class<T> annotationClass, Class clazz) {
        Class superClass = clazz;
        while (!Object.class.equals((Object)superClass)) {
            T annotation = clazz.getAnnotation(annotationClass);
            if (annotation != null) {
                return annotation;
            }
            superClass = superClass.getSuperclass();
        }
        return null;
    }

    public static <T> T getBeanByName(String beanName) {
        return SpringInit.getBeanByName(beanName);
    }

    public static <T> T getBeanByType(Class beanType) {
        return SpringInit.getBeanByType(beanType);
    }

    public static void injectSpringBeans(Object testedObject) {
        if (!SpringEnv.isSpringEnv()) {
            return;
        }
        SpringInit.injectSpringBeans(testedObject);
    }

    public static void invokeBeforeSpringMethod(Class testedClass) {
        Method[] methods;
        for (Method method : methods = testedClass.getMethods()) {
            if (method.getParameterCount() != 0 || !Modifier.isStatic(method.getModifiers()) || method.getAnnotation(BeforeSpring.class) == null) continue;
            method.setAccessible(true);
            try {
                method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                ReflectUtility.doThrow(e);
            }
        }
    }

    public static void doSpringInitial(Object testInstance, ExtensionContext context) throws Exception {
        SpringInit.doSpringInitial(testInstance, context);
    }
}

