/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spring;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextManager;
import org.test4j.Context;
import org.test4j.integration.junit5.JUnit5SpringHelper;
import org.test4j.module.spring.SpringEnv;

public class SpringInit {
    private static Map<Class, WeakReference<ApplicationContext>> springBeanFactories = new HashMap<Class, WeakReference<ApplicationContext>>();
    private static ThreadLocal<TestContextManager> springTestContextManager = new ThreadLocal();

    public static Optional<ApplicationContext> getSpringContext() {
        WeakReference<ApplicationContext> reference = springBeanFactories.get(Context.currTestClass());
        if (reference == null || reference.get() == null) {
            return Optional.empty();
        }
        return Optional.of(reference.get());
    }

    static <T> T getBeanByName(String beanName) {
        T bean = SpringInit.getSpringContext().map(c -> {
            try {
                return c.getBean(beanName);
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }).orElse(null);
        return bean;
    }

    static <T> T getBeanByType(Class beanType) {
        T bean = SpringInit.getSpringContext().map(c -> {
            try {
                return c.getBean(beanType);
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }).orElse(null);
        return bean;
    }

    public static void setSpringContext(Class testClass, ApplicationContext context) {
        springBeanFactories.put(testClass, new WeakReference<ApplicationContext>(context));
    }

    static void injectSpringBeans(Object testedObject) {
        if (!SpringEnv.isSpringEnv()) {
            return;
        }
        AutowireCapableBeanFactory beanFactory = SpringInit.getSpringContext().get().getAutowireCapableBeanFactory();
        beanFactory.autowireBeanProperties(testedObject, 0, false);
        beanFactory.initializeBean(testedObject, testedObject.getClass().getSimpleName());
    }

    public static void doSpringInitial(Object testInstance, ExtensionContext context) throws Exception {
        TestContextManager contextManager = JUnit5SpringHelper.getTestContextManager(context);
        SpringInit.doSpringInitial(testInstance, contextManager);
    }

    public static void doSpringInitial(Object testInstance, TestContextManager contextManager) throws Exception {
        SpringEnv.invokeBeforeSpringMethod(testInstance.getClass());
        springTestContextManager.set(contextManager);
        contextManager.prepareTestInstance(testInstance);
        ApplicationContext applicationContext = SpringInit.getApplicationContext(contextManager);
        SpringInit.setSpringContext(testInstance.getClass(), applicationContext);
    }

    public static ApplicationContext getApplicationContext(TestContextManager contextManager) {
        try {
            Method method = TestContextManager.class.getMethod("getTestContext", new Class[0]);
            method.setAccessible(true);
            TestContext testContext = (TestContext)method.invoke((Object)contextManager, new Object[0]);
            return testContext.getApplicationContext();
        }
        catch (Exception e) {
            throw new RuntimeException("get Spring Application Context error: " + e.getMessage(), e);
        }
    }

    public static TestContextManager getSpringTestContextManager() {
        return springTestContextManager.get();
    }
}

