/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spring;

import java.io.IOException;
import java.util.List;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;

public class YamlPropertyFactory
extends DefaultPropertySourceFactory {
    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        String fileName = resource.getResource().getFilename();
        String string = fileName = fileName == null ? "" : fileName.toLowerCase();
        if (fileName.endsWith(".yaml") || fileName.endsWith(".yml")) {
            return this.loadYaml(resource, fileName);
        }
        return super.createPropertySource(name, resource);
    }

    private PropertySource<?> loadYaml(EncodedResource resource, String fileName) throws IOException {
        List sources = new YamlPropertySourceLoader().load(fileName, resource.getResource());
        return (PropertySource)sources.get(0);
    }
}

