/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseDriver;
import ru.yandex.clickhouse.ClickhouseJdbcUrlParser;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.apache.StringUtils;

public class BalancedClickhouseDataSource
implements DataSource {
    private static final Logger log = LoggerFactory.getLogger(BalancedClickhouseDataSource.class);
    private static final Pattern URL_TEMPLATE = Pattern.compile("jdbc:clickhouse://([a-zA-Z0-9_:,.-]+)(/[a-zA-Z0-9_]+([?][a-zA-Z0-9_]+[=][a-zA-Z0-9_]([&][a-zA-Z0-9_]+[=][a-zA-Z0-9_]+)*)?)?");
    private PrintWriter printWriter;
    private int loginTimeoutSeconds = 0;
    private final ThreadLocal<Random> randomThreadLocal = new ThreadLocal();
    private final List<String> allUrls;
    private volatile List<String> enabledUrls;
    private final ClickHouseProperties properties;
    private final ClickHouseDriver driver = new ClickHouseDriver();

    public BalancedClickhouseDataSource(String url) {
        this(BalancedClickhouseDataSource.splitUrl(url), BalancedClickhouseDataSource.getFromUrl(url));
    }

    public BalancedClickhouseDataSource(String url, Properties properties) {
        this(BalancedClickhouseDataSource.splitUrl(url), new ClickHouseProperties(properties));
    }

    public BalancedClickhouseDataSource(String url, ClickHouseProperties properties) {
        this(BalancedClickhouseDataSource.splitUrl(url), properties.merge(BalancedClickhouseDataSource.getFromUrl(url)));
    }

    private BalancedClickhouseDataSource(List<String> urls) {
        this(urls, new ClickHouseProperties());
    }

    private BalancedClickhouseDataSource(List<String> urls, Properties info) {
        this(urls, new ClickHouseProperties(info));
    }

    private BalancedClickhouseDataSource(List<String> urls, ClickHouseProperties properties) {
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("Incorrect ClickHouse jdbc url list. It must be not empty");
        }
        try {
            ClickHouseProperties localProperties = ClickhouseJdbcUrlParser.parse(urls.get(0), properties.asProperties());
            localProperties.setHost(null);
            localProperties.setPort(-1);
            this.properties = localProperties;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        ArrayList<String> allUrls = new ArrayList<String>(urls.size());
        for (String url : urls) {
            try {
                if (this.driver.acceptsURL(url)) {
                    allUrls.add(url);
                    continue;
                }
                log.error("that url is has not correct format: {}", (Object)url);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("error while checking url: " + url, e);
            }
        }
        if (allUrls.isEmpty()) {
            throw new IllegalArgumentException("there are no correct urls");
        }
        this.allUrls = Collections.unmodifiableList(allUrls);
        this.enabledUrls = this.allUrls;
    }

    static List<String> splitUrl(String url) {
        Matcher m = URL_TEMPLATE.matcher(url);
        if (!m.matches()) {
            throw new IllegalArgumentException("Incorrect url");
        }
        String database = m.group(2);
        if (database == null) {
            database = "";
        }
        String[] hosts = m.group(1).split(",");
        ArrayList<String> result = new ArrayList<String>(hosts.length);
        for (String host : hosts) {
            result.add("jdbc:clickhouse://" + host + database);
        }
        return result;
    }

    private boolean ping(String url) {
        try {
            this.driver.connect(url, this.properties).createStatement().execute("SELECT 1");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized int actualize() {
        ArrayList<String> enabledUrls = new ArrayList<String>(this.allUrls.size());
        for (String url : this.allUrls) {
            log.debug("Pinging disabled url: {}", (Object)url);
            if (this.ping(url)) {
                log.debug("Url is alive now: {}", (Object)url);
                enabledUrls.add(url);
                continue;
            }
            log.debug("Url is dead now: {}", (Object)url);
        }
        this.enabledUrls = Collections.unmodifiableList(enabledUrls);
        return enabledUrls.size();
    }

    private String getAnyUrl() throws SQLException {
        List<String> localEnabledUrls = this.enabledUrls;
        if (localEnabledUrls.isEmpty()) {
            throw new SQLException("Unable to get connection: there are no enabled urls");
        }
        Random random = this.randomThreadLocal.get();
        if (random == null) {
            this.randomThreadLocal.set(new Random(System.currentTimeMillis()));
            random = this.randomThreadLocal.get();
        }
        int index = random.nextInt(localEnabledUrls.size());
        return localEnabledUrls.get(index);
    }

    @Override
    public ClickHouseConnection getConnection() throws SQLException {
        return this.driver.connect(this.getAnyUrl(), this.properties);
    }

    @Override
    public ClickHouseConnection getConnection(String username, String password) throws SQLException {
        return this.driver.connect(this.getAnyUrl(), this.properties.withCredentials(username, password));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printWriter = printWriter;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeoutSeconds = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeoutSeconds;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public BalancedClickhouseDataSource withConnectionsCleaning(int rate, TimeUnit timeUnit) {
        this.driver.scheduleConnectionsCleaning(rate, timeUnit);
        return this;
    }

    public BalancedClickhouseDataSource scheduleActualization(int delay, TimeUnit timeUnit) {
        ClickHouseDriver.ScheduledConnectionCleaner.INSTANCE.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    BalancedClickhouseDataSource.this.actualize();
                }
                catch (Exception e) {
                    log.error("Unable to actualize urls", (Throwable)e);
                }
            }
        }, 0L, delay, timeUnit);
        return this;
    }

    public List<String> getAllClickhouseUrls() {
        return this.allUrls;
    }

    public List<String> getEnabledClickHouseUrls() {
        return this.enabledUrls;
    }

    public List<String> getDisabledUrls() {
        List<String> enabledUrls = this.enabledUrls;
        if (!this.hasDisabledUrls()) {
            return Collections.emptyList();
        }
        ArrayList<String> disabledUrls = new ArrayList<String>(this.allUrls);
        disabledUrls.removeAll(enabledUrls);
        return disabledUrls;
    }

    public boolean hasDisabledUrls() {
        return this.allUrls.size() != this.enabledUrls.size();
    }

    public ClickHouseProperties getProperties() {
        return this.properties;
    }

    private static ClickHouseProperties getFromUrl(String url) {
        if (StringUtils.isBlank(url)) {
            return new ClickHouseProperties();
        }
        int index = url.indexOf("?");
        if (index == -1) {
            return new ClickHouseProperties();
        }
        return new ClickHouseProperties(ClickhouseJdbcUrlParser.parseUriQueryPart(url.substring(index + 1), new Properties()));
    }
}

