/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import ru.yandex.clickhouse.ClickHouseArray;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseStatement;
import ru.yandex.clickhouse.domain.ClickHouseDataType;
import ru.yandex.clickhouse.except.ClickHouseExceptionSpecifier;
import ru.yandex.clickhouse.except.ClickHouseUnknownException;
import ru.yandex.clickhouse.response.AbstractResultSet;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.ClickHouseResultSetMetaData;
import ru.yandex.clickhouse.response.StreamSplitter;
import ru.yandex.clickhouse.response.parser.ClickHouseValueParser;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.ClickHouseArrayUtil;
import ru.yandex.clickhouse.util.ClickHouseBitmap;
import ru.yandex.clickhouse.util.ClickHouseValueFormatter;
import ru.yandex.clickhouse.util.Utils;

public class ClickHouseResultSet
extends AbstractResultSet {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final TimeZone dateTimeTimeZone;
    private final TimeZone dateTimeZone;
    private final StreamSplitter bis;
    private final String db;
    private final String table;
    private List<ClickHouseColumnInfo> columns;
    private int maxRows;
    protected ByteFragment[] values;
    private int lastReadColumn;
    protected ByteFragment nextLine;
    private ByteFragment totalLine;
    protected int rowNumber;
    private final ClickHouseStatement statement;
    private final ClickHouseProperties properties;
    private boolean usesWithTotals;
    private boolean lastReached = false;
    private boolean isAfterLastReached = false;

    public ClickHouseResultSet(InputStream is, int bufferSize, String db, String table, boolean usesWithTotals, ClickHouseStatement statement, TimeZone timeZone, ClickHouseProperties properties) throws IOException {
        this.db = db;
        this.table = table;
        this.statement = statement;
        this.properties = properties;
        this.usesWithTotals = usesWithTotals;
        this.dateTimeTimeZone = timeZone;
        this.dateTimeZone = properties.isUseServerTimeZoneForDates() ? timeZone : TimeZone.getDefault();
        this.bis = new StreamSplitter(is, 10, bufferSize);
        ByteFragment headerFragment = this.bis.next();
        if (headerFragment == null) {
            throw new IllegalArgumentException("ClickHouse response without column names");
        }
        String header = headerFragment.asString(true);
        if (header.startsWith("Code: ") && !header.contains("\t")) {
            is.close();
            throw new IOException("ClickHouse error: " + header);
        }
        String[] cols = ClickHouseResultSet.toStringArray(headerFragment);
        ByteFragment typesFragment = this.bis.next();
        if (typesFragment == null) {
            throw new IllegalArgumentException("ClickHouse response without column types");
        }
        String[] types = ClickHouseResultSet.toStringArray(typesFragment);
        this.columns = new ArrayList<ClickHouseColumnInfo>(cols.length);
        TimeZone tz = null;
        try {
            if (statement != null && statement.getConnection() instanceof ClickHouseConnection) {
                tz = ((ClickHouseConnection)statement.getConnection()).getServerTimeZone();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (tz == null) {
            tz = timeZone;
        }
        for (int i = 0; i < cols.length; ++i) {
            this.columns.add(ClickHouseColumnInfo.parse(types[i], cols[i], tz));
        }
    }

    private static String[] toStringArray(ByteFragment headerFragment) {
        ByteFragment[] split = headerFragment.split((byte)9);
        String[] c = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            String name;
            c[i] = name = split[i].asString(true);
        }
        return c;
    }

    @Deprecated
    public boolean hasNext() throws SQLException {
        if (this.nextLine == null && !this.lastReached) {
            try {
                this.nextLine = this.bis.next();
                if (this.nextLine == null || this.maxRows != 0 && this.rowNumber >= this.maxRows || this.usesWithTotals && this.nextLine.length() == 0) {
                    if (this.usesWithTotals) {
                        if (this.onTheSeparatorRow()) {
                            this.totalLine = this.bis.next();
                            this.endOfStream();
                        }
                    } else {
                        this.endOfStream();
                    }
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return this.nextLine != null;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rowNumber == 0 && this.hasNext();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.isAfterLastReached;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return !this.hasNext();
    }

    private void endOfStream() throws IOException {
        this.bis.close();
        this.lastReached = true;
        this.nextLine = null;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.hasNext()) {
            this.values = this.nextLine.split((byte)9);
            ClickHouseResultSet.checkValues(this.columns, this.values, this.nextLine);
            this.nextLine = null;
            ++this.rowNumber;
            return true;
        }
        this.isAfterLastReached = true;
        return false;
    }

    private boolean onTheSeparatorRow() throws IOException {
        this.bis.mark();
        boolean onSeparatorRow = this.bis.next() != null && this.bis.next() == null;
        this.bis.reset();
        return onSeparatorRow;
    }

    private static void checkValues(List<ClickHouseColumnInfo> columns, ByteFragment[] values, ByteFragment fragment) throws SQLException {
        if (columns.size() != values.length) {
            throw ClickHouseExceptionSpecifier.specify(fragment.asString());
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.bis.close();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.bis.isClosed();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public void getTotals() throws SQLException {
        if (!this.usesWithTotals) {
            throw new IllegalStateException("Cannot get totals when totals are not being used.");
        }
        this.nextLine = this.totalLine;
        this.next();
    }

    List<ClickHouseColumnInfo> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ClickHouseResultSetMetaData(this);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastReadColumn == 0) {
            throw new IllegalStateException("You should get something before check nullability");
        }
        return this.getValue(this.lastReadColumn).isNull();
    }

    @Override
    public int getInt(String column) throws SQLException {
        return this.getInt(this.findColumn(column));
    }

    @Override
    public boolean getBoolean(String column) throws SQLException {
        return this.getBoolean(this.findColumn(column));
    }

    @Override
    public long getLong(String column) throws SQLException {
        return this.getLong(this.findColumn(column));
    }

    @Override
    public String getString(String column) throws SQLException {
        return this.getString(this.findColumn(column));
    }

    @Override
    public byte[] getBytes(String column) throws SQLException {
        return this.getBytes(this.findColumn(column));
    }

    @Override
    public Timestamp getTimestamp(String column) throws SQLException {
        return this.getTimestamp(this.findColumn(column));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        ClickHouseColumnInfo columnInfo = this.getColumnInfo(columnIndex);
        TimeZone tz = this.getEffectiveTimeZone(columnInfo);
        return ClickHouseValueParser.getParser(Timestamp.class).parse(this.getValue(columnIndex), columnInfo, tz);
    }

    private TimeZone getEffectiveTimeZone(ClickHouseColumnInfo columnInfo) {
        TimeZone tz = null;
        tz = columnInfo.getClickHouseDataType() == ClickHouseDataType.Date ? this.dateTimeZone : (this.properties.isUseServerTimeZone() ? null : this.dateTimeTimeZone);
        return tz;
    }

    @Override
    public Timestamp getTimestamp(String column, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(column), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public short getShort(String column) throws SQLException {
        return this.getShort(this.findColumn(column));
    }

    @Override
    public byte getByte(String column) throws SQLException {
        return this.getByte(this.findColumn(column));
    }

    @Override
    public long[] getLongArray(String column) throws SQLException {
        return this.getLongArray(this.findColumn(column));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        Object array;
        ClickHouseColumnInfo colInfo = this.getColumnInfo(columnIndex);
        if (colInfo.getClickHouseDataType() != ClickHouseDataType.Array) {
            throw new SQLException("Column not an array");
        }
        switch (colInfo.getArrayBaseType()) {
            case Date: {
                array = ClickHouseArrayUtil.parseArray(this.getValue(columnIndex), this.properties.isUseObjectsInArrays(), this.dateTimeZone, colInfo);
                break;
            }
            default: {
                TimeZone timeZone = colInfo.getTimeZone() != null ? colInfo.getTimeZone() : this.dateTimeTimeZone;
                array = ClickHouseArrayUtil.parseArray(this.getValue(columnIndex), this.properties.isUseObjectsInArrays(), timeZone, colInfo);
            }
        }
        return new ClickHouseArray(colInfo.getArrayBaseType(), array);
    }

    @Override
    public Array getArray(String column) throws SQLException {
        return this.getArray(this.findColumn(column));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public String getString(int colNum) throws SQLException {
        ClickHouseColumnInfo columnInfo = this.getColumnInfo(colNum);
        ByteFragment value = this.getValue(colNum);
        ClickHouseDataType dataType = columnInfo.getClickHouseDataType();
        if (!(this.properties.isUseServerTimeZone() || dataType != ClickHouseDataType.DateTime && dataType != ClickHouseDataType.DateTime32 && dataType != ClickHouseDataType.DateTime64)) {
            TimeZone clientTimeZone;
            TimeZone serverTimeZone = columnInfo.getTimeZone();
            if (serverTimeZone == null) {
                serverTimeZone = ((ClickHouseConnection)this.getStatement().getConnection()).getServerTimeZone();
            }
            TimeZone timeZone = clientTimeZone = Utils.isNullOrEmptyString(this.properties.getUseTimeZone()) ? TimeZone.getDefault() : TimeZone.getTimeZone(this.properties.getUseTimeZone());
            if (!clientTimeZone.equals(serverTimeZone)) {
                Timestamp newTs = ClickHouseValueParser.getParser(Timestamp.class).parse(value, columnInfo, serverTimeZone);
                value = ByteFragment.fromString(ClickHouseValueFormatter.formatTimestamp(newTs, clientTimeZone));
            }
        }
        return ClickHouseValueParser.getParser(String.class).parse(value, columnInfo, null);
    }

    @Override
    public int getInt(int colNum) throws SQLException {
        return ClickHouseValueParser.parseInt(this.getValue(colNum), this.getColumnInfo(colNum));
    }

    @Override
    public boolean getBoolean(int colNum) throws SQLException {
        return ClickHouseValueParser.parseBoolean(this.getValue(colNum), this.getColumnInfo(colNum));
    }

    @Override
    public long getLong(int colNum) throws SQLException {
        return ClickHouseValueParser.parseLong(this.getValue(colNum), this.getColumnInfo(colNum));
    }

    @Override
    public byte[] getBytes(int colNum) {
        return ClickHouseResultSet.toBytes(this.getValue(colNum));
    }

    @Deprecated
    public Long getTimestampAsLong(int colNum) {
        ClickHouseColumnInfo columnInfo = this.getColumnInfo(colNum);
        TimeZone tz = this.getEffectiveTimeZone(columnInfo);
        return this.getTimestampAsLong(colNum, tz);
    }

    @Deprecated
    public Long getTimestampAsLong(int colNum, TimeZone timeZone) {
        ByteFragment value = this.getValue(colNum);
        if (value.isNull() || value.asString().equals("0000-00-00 00:00:00")) {
            return null;
        }
        try {
            Instant instant = ClickHouseValueParser.getParser(Instant.class).parse(value, this.getColumnInfo(colNum), timeZone);
            return instant.toEpochMilli();
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
    }

    @Override
    public short getShort(int colNum) throws SQLException {
        return ClickHouseValueParser.parseShort(this.getValue(colNum), this.getColumnInfo(colNum));
    }

    @Override
    public byte getByte(int colNum) {
        return ClickHouseResultSet.toByte(this.getValue(colNum));
    }

    @Deprecated
    public long[] getLongArray(int colNum) throws SQLException {
        return ClickHouseResultSet.toLongArray(this.getValue(colNum), this.getColumnInfo(colNum));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return ClickHouseValueParser.parseFloat(this.getValue(columnIndex), this.getColumnInfo(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return ClickHouseValueParser.parseDouble(this.getValue(columnIndex), this.getColumnInfo(columnIndex));
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        ClickHouseColumnInfo columnInfo = this.getColumnInfo(columnIndex);
        TimeZone tz = this.getEffectiveTimeZone(columnInfo);
        return ClickHouseValueParser.getParser(Date.class).parse(this.getValue(columnIndex), columnInfo, tz);
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        ClickHouseColumnInfo columnInfo = this.getColumnInfo(columnIndex);
        TimeZone tz = this.getEffectiveTimeZone(columnInfo);
        return ClickHouseValueParser.getParser(Time.class).parse(this.getValue(columnIndex), columnInfo, tz);
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            if (this.getValue(columnIndex).isNull()) {
                return null;
            }
            ClickHouseColumnInfo columnInfo = this.getColumnInfo(columnIndex);
            ClickHouseDataType chType = columnInfo.getClickHouseDataType();
            switch (chType.getSqlType()) {
                case -5: {
                    if (chType == ClickHouseDataType.UInt64) {
                        return this.getObject(columnIndex, BigInteger.class);
                    }
                    return this.getObject(columnIndex, Long.class);
                }
                case 4: {
                    if (!chType.isSigned()) {
                        return this.getObject(columnIndex, Long.class);
                    }
                    return this.getObject(columnIndex, Integer.class);
                }
                case -6: 
                case 5: {
                    return this.getObject(columnIndex, Integer.class);
                }
                case 12: {
                    return this.getString(columnIndex);
                }
                case 7: {
                    return this.getObject(columnIndex, Float.class);
                }
                case 6: 
                case 8: {
                    return this.getObject(columnIndex, Double.class);
                }
                case 91: {
                    return this.getDate(columnIndex);
                }
                case 93: {
                    return this.getTimestamp(columnIndex);
                }
                case 2004: {
                    return this.getString(columnIndex);
                }
                case 2003: {
                    return this.getArray(columnIndex);
                }
                case 3: {
                    return this.getBigDecimal(columnIndex);
                }
                case 2: {
                    return this.getBigInteger(columnIndex);
                }
            }
            switch (chType) {
                case AggregateFunction: {
                    if ("groupBitmap".equals(columnInfo.getFunctionName())) {
                        ClickHouseDataType innerType = columnInfo.getArrayBaseType();
                        switch (innerType) {
                            case Int8: 
                            case Int16: 
                            case Int32: 
                            case Int64: 
                            case UInt8: 
                            case UInt16: 
                            case UInt32: 
                            case UInt64: {
                                return this.getObject(columnIndex, ClickHouseBitmap.class);
                            }
                        }
                    }
                    return this.getString(columnIndex);
                }
                case Map: 
                case UUID: {
                    return this.getObject(columnIndex, chType.getJavaClass());
                }
            }
            return this.getString(columnIndex);
        }
        catch (Exception e) {
            throw new ClickHouseUnknownException("Parse exception: " + this.values[columnIndex - 1].toString(), e);
        }
    }

    private static byte toByte(ByteFragment value) {
        if (value.isNull()) {
            return 0;
        }
        return Byte.parseByte(value.asString());
    }

    private static byte[] toBytes(ByteFragment value) {
        if (value.isNull()) {
            return null;
        }
        return value.unescape();
    }

    static long[] toLongArray(ByteFragment value, ClickHouseColumnInfo columnInfo) throws SQLException {
        if (value.isNull()) {
            return null;
        }
        if (value.charAt(0) != 91 || value.charAt(value.length() - 1) != 93) {
            throw new IllegalArgumentException("not an array: " + value);
        }
        if (value.length() == 2) {
            return EMPTY_LONG_ARRAY;
        }
        ByteFragment trim = value.subseq(1, value.length() - 2);
        ByteFragment[] values = trim.split((byte)44);
        long[] result = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = ClickHouseValueParser.parseLong(values[i], columnInfo);
        }
        return result;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowNumber;
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public int findColumn(String column) throws SQLException {
        if (column == null || column.isEmpty()) {
            throw new ClickHouseUnknownException("column name required", null);
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!column.equalsIgnoreCase(this.columns.get(i).getColumnName())) continue;
            return i + 1;
        }
        throw new SQLException("no column " + column + " in columns list " + this.getColumnNamesString());
    }

    private ByteFragment getValue(int colNum) {
        this.lastReadColumn = colNum;
        return this.values[colNum - 1];
    }

    private ClickHouseColumnInfo getColumnInfo(int colNum) {
        return this.columns.get(colNum - 1);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (String.class.equals(type)) {
            return (T)this.getString(columnIndex);
        }
        ClickHouseColumnInfo columnInfo = this.getColumnInfo(columnIndex);
        TimeZone tz = this.getEffectiveTimeZone(columnInfo);
        return (T)(columnInfo.isArray() ? (Array.class.isAssignableFrom(type) ? this.getArray(columnIndex) : this.getArray(columnIndex).getArray()) : ClickHouseValueParser.getParser(type).parse(this.getValue(columnIndex), columnInfo, tz));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Deprecated
    public ByteFragment[] getValues() {
        return this.values;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return ClickHouseValueParser.getParser(BigDecimal.class).parse(this.getValue(columnIndex), this.getColumnInfo(columnIndex), null);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal result = ClickHouseValueParser.getParser(BigDecimal.class).parse(this.getValue(columnIndex), this.getColumnInfo(columnIndex), null);
        return result != null ? result.setScale(scale, RoundingMode.HALF_UP) : null;
    }

    public BigInteger getBigInteger(String columnLabel) throws SQLException {
        return this.getBigInteger(this.findColumn(columnLabel));
    }

    public BigInteger getBigInteger(int columnIndex) throws SQLException {
        BigDecimal dec = this.getBigDecimal(columnIndex);
        return dec == null ? null : dec.toBigInteger();
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            columnNames[i] = this.columns.get(i).getColumnName();
        }
        return columnNames;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    public String toString() {
        return "ClickHouseResultSet{dateTimeTimeZone=" + this.dateTimeTimeZone.toString() + ", dateTimeZone=" + this.dateTimeZone.toString() + ", bis=" + this.bis + ", db='" + this.db + '\'' + ", table='" + this.table + '\'' + ", columns=" + this.getColumnNamesString() + ", maxRows=" + this.maxRows + ", values=" + Arrays.toString(this.values) + ", lastReadColumn=" + this.lastReadColumn + ", nextLine=" + this.nextLine + ", rowNumber=" + this.rowNumber + ", statement=" + this.statement + '}';
    }

    private String getColumnNamesString() {
        StringBuilder sb = new StringBuilder();
        for (ClickHouseColumnInfo info : this.columns) {
            sb.append(info.getColumnName()).append(' ');
        }
        return sb.substring(0, sb.length() - 1);
    }
}

