/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.instrumentation;

import com.intellij.compiler.instrumentation.ClassFinderClasspath;
import com.intellij.compiler.instrumentation.PseudoClass;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import se.eris.asm.ClassInfoVisitor;
import se.eris.notnull.instrumentation.Resource;

public class InstrumentationClassFinder {
    private static final String CLASS_RESOURCE_EXTENSION = ".class";
    @NotNull
    private final Map<String, PseudoClass> myLoaded = new HashMap<String, PseudoClass>();
    @NotNull
    private final ClassFinderClasspath classpath;

    public InstrumentationClassFinder(URL[] cp) {
        this.classpath = new ClassFinderClasspath(cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    PseudoClass loadClass(String name) throws IOException, ClassNotFoundException {
        String internalName = name.replace('.', '/');
        PseudoClass aClass = this.myLoaded.get(internalName);
        if (aClass != null) {
            return aClass;
        }
        String resourceName = internalName + CLASS_RESOURCE_EXTENSION;
        Resource resource = this.classpath.getResource(resourceName);
        InputStream is = resource == null ? ClassLoader.getSystemResourceAsStream(resourceName) : resource.getInputStream();
        if (is == null) {
            throw new ClassNotFoundException("Class not found: " + internalName);
        }
        try {
            PseudoClass result = this.loadPseudoClass(is);
            this.myLoaded.put(internalName, result);
            PseudoClass pseudoClass = result;
            return pseudoClass;
        }
        finally {
            is.close();
        }
    }

    @NotNull
    private PseudoClass loadPseudoClass(InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        ClassInfoVisitor visitor = new ClassInfoVisitor();
        reader.accept((ClassVisitor)visitor, 7);
        return new PseudoClass(this, visitor.getClassInfo());
    }
}

