/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.eris.asm.ClassInfo;

final class PseudoClass {
    static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final PseudoClass[] EMPTY_PSEUDOCLASS_ARRAY = new PseudoClass[0];
    @NotNull
    private final InstrumentationClassFinder instrumentationClassFinder;
    @NotNull
    private final ClassInfo classInfo;

    PseudoClass(@NotNull InstrumentationClassFinder instrumentationClassFinder, @NotNull ClassInfo classInfo) {
        this.instrumentationClassFinder = instrumentationClassFinder;
        this.classInfo = classInfo;
    }

    boolean isInterface() {
        return this.classInfo.isInterface();
    }

    @NotNull
    String getName() {
        return this.classInfo.getName();
    }

    @Nullable
    PseudoClass getSuperClass() throws IOException, ClassNotFoundException {
        String superClass = this.classInfo.getSuperName();
        return superClass == null ? null : this.instrumentationClassFinder.loadClass(superClass);
    }

    private PseudoClass[] getImplementedInterfaces() throws IOException, ClassNotFoundException {
        String[] interfaces = this.classInfo.getInterfaces();
        if (interfaces.length == 0) {
            return EMPTY_PSEUDOCLASS_ARRAY;
        }
        PseudoClass[] result = new PseudoClass[interfaces.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.instrumentationClassFinder.loadClass(interfaces[i]);
        }
        return result;
    }

    private boolean isSubclassOf(@NotNull PseudoClass pseudoClass) throws IOException, ClassNotFoundException {
        for (PseudoClass c = this; c != null; c = c.getSuperClass()) {
            PseudoClass superClass = c.getSuperClass();
            if (superClass == null || !superClass.equals(pseudoClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isImplementedBy(PseudoClass pseudoClass) throws IOException, ClassNotFoundException {
        for (PseudoClass thisClassChain = this; thisClassChain != null; thisClassChain = thisClassChain.getSuperClass()) {
            for (PseudoClass implementedInterface : thisClassChain.getImplementedInterfaces()) {
                if (!implementedInterface.equals(pseudoClass) && !implementedInterface.isImplementedBy(pseudoClass)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAssignableFrom(PseudoClass pseudoClass) throws IOException, ClassNotFoundException {
        if (this.equals(pseudoClass)) {
            return true;
        }
        if (pseudoClass.isSubclassOf(this)) {
            return true;
        }
        if (pseudoClass.isImplementedBy(this)) {
            return true;
        }
        return this.isObject() && pseudoClass.isInterface();
    }

    private boolean isObject() {
        return JAVA_LANG_OBJECT.equals(this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PseudoClass that = (PseudoClass)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "PseudoClass{classInfo=" + this.classInfo + '}';
    }
}

