/*
 * Decompiled with CFR 0.152.
 */
package se.eris.notnull;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import se.eris.notnull.AnnotationConfiguration;
import se.eris.notnull.ExcludeConfiguration;
import se.eris.notnull.NotNull;
import se.eris.notnull.Nullable;

public class Configuration {
    private final boolean implicit;
    @org.jetbrains.annotations.NotNull
    private final AnnotationConfiguration annotationConfiguration;
    @org.jetbrains.annotations.NotNull
    private final ExcludeConfiguration excludeConfiguration;

    public Configuration(boolean implicit, @org.jetbrains.annotations.NotNull AnnotationConfiguration annotationConfiguration, @org.jetbrains.annotations.NotNull ExcludeConfiguration excludeConfiguration) {
        this.implicit = implicit;
        this.annotationConfiguration = annotationConfiguration.isAnnotationsConfigured() ? annotationConfiguration : new AnnotationConfiguration(this.getDefaultNotNull(), this.getDefaultNullable());
        this.excludeConfiguration = excludeConfiguration;
    }

    @org.jetbrains.annotations.NotNull
    private Set<String> getDefaultNotNull() {
        return new HashSet<String>(Arrays.asList(org.jetbrains.annotations.NotNull.class.getName(), NotNull.class.getName()));
    }

    @org.jetbrains.annotations.NotNull
    private Set<String> getDefaultNullable() {
        return new HashSet<String>(Arrays.asList(org.jetbrains.annotations.Nullable.class.getName(), Nullable.class.getName()));
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    @org.jetbrains.annotations.NotNull
    public Set<String> getNotNullAnnotations() {
        return this.annotationConfiguration.getNotNull();
    }

    @org.jetbrains.annotations.NotNull
    public Set<String> getNullableAnnotations() {
        return this.annotationConfiguration.getNullable();
    }

    public boolean isImplicitInstrumentation(String className) {
        return this.implicit && this.excludeConfiguration.isClassImplicitInstrumentation(className);
    }
}

