/*
 * Decompiled with CFR 0.152.
 */
package se.eris.notnull.instrumentation;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import se.eris.util.string.StringReplacer;

public final class ClassMatcher {
    private static final StringReplacer PATTERN_REPLACER = StringReplacer.init().prefix("^").add("$", "\\$").add(".**", "(\\.[^\\.]*)*").add(".", "\\.").add("**", ".*").add("*", "[^\\.]*").suffix("$").build();
    @NotNull
    private final Pattern pattern;

    @NotNull
    public static ClassMatcher namePattern(@NotNull String classNamePattern) {
        String pattern = PATTERN_REPLACER.apply(classNamePattern);
        return new ClassMatcher(Pattern.compile(pattern));
    }

    private ClassMatcher(@NotNull Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassMatcher aClassMatcher = (ClassMatcher)o;
        return this.pattern.equals(aClassMatcher.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean matches(CharSequence classFileName) {
        return this.pattern.matcher(classFileName).matches();
    }
}

