/*
 * Decompiled with CFR 0.152.
 */
package se.eris.util.string;

import org.jetbrains.annotations.Contract;

public class StringAnalyzer {
    private final String string;

    public StringAnalyzer(String string) {
        this.string = string;
    }

    public int length() {
        return this.string.length();
    }

    public boolean isCharAt(int offset, char c) {
        return this.hasChar(offset) && this.string.charAt(offset) == c;
    }

    public boolean isStringAt(int offset, String s) {
        if (offset + s.length() > this.string.length()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (this.isCharAt(i + offset, s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    private boolean hasChar(int offset) {
        return offset >= 0 && offset < this.string.length();
    }

    public char charAt(int offset) {
        return this.string.charAt(offset);
    }
}

