/*
 * Decompiled with CFR 0.152.
 */
package se.eris.util.string;

import java.util.List;
import se.eris.util.string.Replacement;
import se.eris.util.string.StringAnalyzer;

class StringWorker {
    private final StringBuilder stringBuilder = new StringBuilder();
    private final StringAnalyzer stringAnalyzer;
    private int index;

    StringWorker(String s) {
        this.stringAnalyzer = new StringAnalyzer(s);
        this.index = 0;
    }

    private void step() {
        this.stringBuilder.append(this.stringAnalyzer.charAt(this.index));
        ++this.index;
    }

    public void insert(String s) {
        this.stringBuilder.append(s);
    }

    private boolean isDone() {
        return this.index >= this.stringAnalyzer.length();
    }

    public void replaceInOrder(List<Replacement> replacements) {
        while (!this.isDone()) {
            if (this.replaceFirstMatching(replacements)) continue;
            this.step();
        }
    }

    private boolean replaceFirstMatching(List<Replacement> replacements) {
        for (Replacement replacement : replacements) {
            if (!this.replaceIfMatch(replacement)) continue;
            return true;
        }
        return false;
    }

    private boolean replaceIfMatch(Replacement replacement) {
        String replace = replacement.getReplace();
        if (this.stringAnalyzer.isStringAt(this.index, replace)) {
            this.stringBuilder.append(replacement.getWith());
            this.index += replace.length();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

