package com.coolxiaoyao.common.annotation;

import java.lang.annotation.*;


/**
 * 只支持 int,long,short,float,double,boolean,char,byte 和其对应的包装类型
 * String,List<String>,数组
 * TODO
 * <pre>
 *
 *     List<String> 用数组时,只接受泛型String
 * </pre>
 */
@Target(ElementType.PARAMETER)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RequestParam {

    /**
     * 参数名
     *
     * @return
     */
    String value() default "";

    /**
     * 是否是必须
     *
     * @return
     */
    boolean required() default true;

    /**
     * 默认值
     *
     * @return
     */
    String defaultValue() default "";

}
