package com.coolxiaoyao.common.core;

/**
 * @author Kerry on 18/09/20
 */

public interface IContainerInitializer {

    /**
     * 启动
     *
     * @param packageNames
     */
    void startup(String... packageNames) throws Exception;

    /**
     * 开启
     *
     * @param args
     * @param primaryClass
     * @throws Exception
     */
    default void startup(String[] args, Class<?>... primaryClass) throws Exception {
        startup(args, true, primaryClass);
    }

    /**
     * 开启
     *
     * @param args
     * @param isPackage    是不是包名,如果False,只会扫描 #primaryClass 指定的类,而不是包名
     * @param primaryClass
     * @throws Exception
     */
    void startup(String[] args, boolean isPackage, Class<?>... primaryClass) throws Exception;

}
