package com.coolxiaoyao.common.http;

/**
 * @author Kerry on 18/09/20
 */

public enum HttpMethod {

    /**
     * GET
     */
    GET("GET"),
    /**
     * POST
     */
    POST("POST"),
    /**
     * DELETE
     */
    DELETE("DELETE"),
    /**
     * PUT
     */
    PUT("PUT");

    private String name;

    HttpMethod(String name) {
        this.name = name;
    }

    public static HttpMethod fromType(String type) {
        for (HttpMethod value : values()) {
            if (value.name.equalsIgnoreCase(type)) {
                return value;
            }
        }
        throw new IllegalArgumentException(type);
    }
}
