package com.coolxiaoyao.common.inner;

import java.io.Serializable;

/**
 * @author Kerry on 18/09/25
 */

public class DefaultResponseBody implements Serializable {
    private final int status;
    private final String msg;
    private final Object data;
    private final String mediaType;


    private DefaultResponseBody(Builder builder) {
        status = builder.status;
        msg = builder.msg;
        data = builder.data;
        mediaType = builder.mediaType;
    }

    public int getStatus() {
        return status;
    }

    public String getMsg() {
        return msg;
    }

    public Object getData() {
        return data;
    }

    public String getMediaType() {
        return mediaType;
    }

    public static final class Builder {
        private int status;
        private String msg;
        private Object data;
        private String mediaType;

        public Builder() {
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }


        public DefaultResponseBody build() {
            return new DefaultResponseBody(this);
        }
    }

    @Override
    public String toString() {
        return "DefaultResponseBody{" +
                "status=" + status +
                ", msg='" + msg + '\'' +
                ", data=" + data +
                '}';
    }
}
