package com.coolxiaoyao.common.inner;

import com.coolxiaoyao.common.annotation.Inner;
import com.coolxiaoyao.common.http.HttpMethod;
import com.coolxiaoyao.common.mapping.UrlMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * @author Kerry on 18/09/25
 * @InnerModule
 */

@Inner
public class UrlInnerExchange {
    private String sourceUrl;
    private String patternStr;
    private Map<HttpMethod, UrlMapping> urlMappingMap;

    public UrlInnerExchange() {
    }

    public UrlInnerExchange(@NotNull String sourceUrl, @Nullable String patternStr, @NotNull Map<HttpMethod, UrlMapping> urlMappingMap) {
        this.sourceUrl = sourceUrl;
        this.patternStr = patternStr;
        this.urlMappingMap = urlMappingMap;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getPatternStr() {
        return patternStr;
    }

    public void setPatternStr(String patternStr) {
        this.patternStr = patternStr;
    }

    public Map<HttpMethod, UrlMapping> getUrlMappingMap() {
        return urlMappingMap;
    }

    public void setUrlMappingMap(Map<HttpMethod, UrlMapping> urlMappingMap) {
        this.urlMappingMap = urlMappingMap;
    }

    @Override
    public String toString() {
        return "PathVariableInnerExchange{" +
                "sourceUrl='" + sourceUrl + '\'' +
                ", patternStr='" + patternStr + '\'' +
                ", urlMappingMap=" + urlMappingMap +
                '}';
    }
}
