/*
 * Decompiled with CFR 0.152.
 */
package com.coolxiaoyao.common.context;

import com.coolxiaoyao.common.core.IContainerInitializer;
import com.coolxiaoyao.common.handler.AnnotationHandler;
import com.coolxiaoyao.common.http.ExceptionHandler;
import com.coolxiaoyao.common.http.HttpMethod;
import com.coolxiaoyao.common.inner.UrlInnerExchange;
import com.coolxiaoyao.common.mapping.UrlMapping;
import java.util.Map;

public abstract class AbstractNtApplicationContext
implements IContainerInitializer {
    protected Map<String, Map<HttpMethod, UrlMapping>> urlMapping;
    protected ExceptionHandler exceptionHandler;

    @Override
    public void startup(String ... packageNames) throws Exception {
        this.beforeContainerInit(null, packageNames);
        this.urlMapping = AnnotationHandler.scannerByPackage(packageNames);
        this.afterContainerInit(null, packageNames);
    }

    @Override
    public void startup(String[] args, boolean isPackage, Class<?> ... primaryClass) throws Exception {
        this.beforeContainerInit(args, primaryClass);
        if (isPackage) {
            String[] packageNames = new String[primaryClass.length];
            for (int i = 0; i < primaryClass.length; ++i) {
                packageNames[i] = primaryClass[i].getPackage().getName();
            }
            this.urlMapping = AnnotationHandler.scannerByPackage(packageNames);
        } else {
            this.urlMapping = AnnotationHandler.scannerByClass(primaryClass);
        }
        this.afterContainerInit(args, primaryClass);
    }

    protected abstract void beforeContainerInit(String[] var1, Object[] var2);

    protected abstract void afterContainerInit(String[] var1, Object[] var2);

    public abstract UrlInnerExchange matchUrlMapping(String var1);

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public Map<String, Map<HttpMethod, UrlMapping>> getUrlMapping() {
        return this.urlMapping;
    }

    public void setUrlMapping(Map<String, Map<HttpMethod, UrlMapping>> urlMapping) {
        this.urlMapping = urlMapping;
    }
}

