/*
 * Decompiled with CFR 0.152.
 */
package com.coolxiaoyao.common.handler;

import com.coolxiaoyao.common.annotation.DeleteMapping;
import com.coolxiaoyao.common.annotation.GetMapping;
import com.coolxiaoyao.common.annotation.PathVariable;
import com.coolxiaoyao.common.annotation.PostMapping;
import com.coolxiaoyao.common.annotation.PutMapping;
import com.coolxiaoyao.common.annotation.RequestBody;
import com.coolxiaoyao.common.annotation.RequestParam;
import com.coolxiaoyao.common.annotation.RestController;
import com.coolxiaoyao.common.exception.MappingException;
import com.coolxiaoyao.common.http.HttpMethod;
import com.coolxiaoyao.common.mapping.UrlMapping;
import com.coolxiaoyao.common.util.ClassUtil;
import com.coolxiaoyao.common.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnnotationHandler {
    private Map<String, Map<HttpMethod, UrlMapping>> urlMapping = new ConcurrentHashMap<String, Map<HttpMethod, UrlMapping>>();

    public static Map<String, Map<HttpMethod, UrlMapping>> scannerByClass(Class<?> ... primaryClass) throws Exception {
        return new AnnotationHandler().scannerUrlMapping(primaryClass);
    }

    public static Map<String, Map<HttpMethod, UrlMapping>> scannerByPackage(String ... primaryClass) throws Exception {
        return new AnnotationHandler().scannerUrlMapping(primaryClass);
    }

    private AnnotationHandler() {
    }

    private Map<String, Map<HttpMethod, UrlMapping>> scannerUrlMapping(Class<?> ... primaryClass) throws Exception {
        for (Class<?> clazz : primaryClass) {
            if (clazz.getAnnotation(RestController.class) == null) continue;
            this.initRestControllerClass(clazz);
        }
        return this.urlMapping;
    }

    private Map<String, Map<HttpMethod, UrlMapping>> scannerUrlMapping(String ... primaryClass) throws Exception {
        Set<Class<?>> classSet = ClassUtil.scannerClassByAnnotation(RestController.class, primaryClass);
        for (Class<?> clazz : classSet) {
            this.initRestControllerClass(clazz);
        }
        return this.urlMapping;
    }

    private void initRestControllerClass(Class<?> clazz) throws InstantiationException, IllegalAccessException, MappingException {
        Method[] declaredMethods;
        RestController annotation = clazz.getAnnotation(RestController.class);
        assert (annotation != null);
        String prefix = annotation.value();
        Object controller = clazz.newInstance();
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            DeleteMapping deleteMapping;
            PutMapping putMapping;
            PostMapping postMapping;
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            LinkedHashMap<String, HttpMethod> urlMethod = new LinkedHashMap<String, HttpMethod>(8);
            GetMapping getMapping = method.getDeclaredAnnotation(GetMapping.class);
            if (getMapping != null) {
                String url = this.checkUrlValid(prefix, getMapping.value());
                urlMethod.put(url, HttpMethod.GET);
            }
            if ((postMapping = method.getDeclaredAnnotation(PostMapping.class)) != null) {
                String url = this.checkUrlValid(prefix, postMapping.value());
                urlMethod.put(url, HttpMethod.POST);
            }
            if ((putMapping = method.getDeclaredAnnotation(PutMapping.class)) != null) {
                String url = this.checkUrlValid(prefix, putMapping.value());
                urlMethod.put(url, HttpMethod.PUT);
            }
            if ((deleteMapping = method.getDeclaredAnnotation(DeleteMapping.class)) != null) {
                String url = this.checkUrlValid(prefix, deleteMapping.value());
                urlMethod.put(url, HttpMethod.DELETE);
            }
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                if (parameterAnnotations[i].length <= 0) continue;
                boolean isPathVariable = false;
                boolean isRequestBody = false;
                boolean isRequestParam = false;
                for (Annotation tempAnnotation : parameterAnnotations[i]) {
                    boolean b;
                    if (tempAnnotation instanceof RequestBody) {
                        isRequestBody = true;
                        b = ClassUtil.supportRequestBodyClassType(parameterTypes[i]);
                        if (!b) {
                            throw new MappingException("Annotation. Class: " + RequestBody.class + ", UnSupport ClassType." + parameterTypes[i] + ",in " + method);
                        }
                    }
                    if (tempAnnotation instanceof RequestParam) {
                        isRequestParam = true;
                        b = ClassUtil.supportRequestParamClassType(parameterTypes[i]);
                        if (!b) {
                            throw new MappingException("Annotation. Class: " + RequestParam.class + ", UnSupport ClassType." + parameterTypes[i] + ",in " + method);
                        }
                    }
                    if (!(tempAnnotation instanceof PathVariable)) continue;
                    isPathVariable = true;
                    boolean isSupport = ClassUtil.supportPathVariableClassType(parameterTypes[i]);
                    if (!isSupport) {
                        throw new MappingException("Annotation. Class: " + PathVariable.class + ", UnSupport ClassType." + parameterTypes[i] + ",in " + method);
                    }
                    LinkedHashMap tempMap = new LinkedHashMap(urlMethod.size());
                    for (Map.Entry entry : urlMethod.entrySet()) {
                        String url = (String)entry.getKey();
                        CharSequence[] split = url.split("/");
                        String keyName = "{" + ((PathVariable)tempAnnotation).value() + "}";
                        int pathVariableCount = 0;
                        for (int p = 0; p < split.length; ++p) {
                            if (!keyName.equals(split[p])) continue;
                            ++pathVariableCount;
                            split[p] = "([-A-Za-z0-9+&@#%?=~_|!:,.;]+)";
                        }
                        if (pathVariableCount != 1) {
                            throw new MappingException(method + "; url =" + url + "; " + PathVariable.class + " 'value = " + keyName);
                        }
                        tempMap.put(String.join((CharSequence)"/", split), entry.getValue());
                    }
                    urlMethod.clear();
                    urlMethod.putAll(tempMap);
                }
                if (!isPathVariable || !isRequestBody || !isRequestParam) continue;
                throw new MappingException("both Annotation coexist." + RequestBody.class + "," + PathVariable.class);
            }
            for (Map.Entry methodEntry : urlMethod.entrySet()) {
                UrlMapping put;
                String url = (String)methodEntry.getKey();
                HttpMethod httpMethod = (HttpMethod)((Object)methodEntry.getValue());
                Map<HttpMethod, UrlMapping> temp = this.urlMapping.get(url);
                if (temp == null) {
                    temp = new HashMap<HttpMethod, UrlMapping>(4);
                }
                if ((put = temp.put(httpMethod, new UrlMapping(controller, method, parameterTypes))) != null) {
                    throw new MappingException("class: " + clazz + ",method: " + method + ",url: " + url);
                }
                this.urlMapping.put(url, temp);
            }
        }
    }

    private String checkUrlValid(String prefix, String value) throws MappingException {
        String url = prefix + value;
        if (StringUtils.isBlank(url)) {
            throw new MappingException("URL is Empty in method: ");
        }
        return url;
    }

    @Deprecated
    private List<String> mappingAnnotation(String prefix, Class<?> clazz, Object controllerInstance, Method method) throws MappingException {
        DeleteMapping deleteMapping;
        PutMapping putMapping;
        PostMapping postMapping;
        ArrayList<String> urls = new ArrayList<String>(6);
        GetMapping getMapping = method.getDeclaredAnnotation(GetMapping.class);
        if (getMapping != null) {
            String url = this.checkUrlValid(prefix, getMapping.value());
            url = this.mappingAnnotationOne(url, HttpMethod.GET, clazz, controllerInstance, method);
            urls.add(url);
        }
        if ((postMapping = method.getDeclaredAnnotation(PostMapping.class)) != null) {
            String url = this.checkUrlValid(prefix, postMapping.value());
            url = this.mappingAnnotationOne(url, HttpMethod.POST, clazz, controllerInstance, method);
            urls.add(url);
        }
        if ((putMapping = method.getDeclaredAnnotation(PutMapping.class)) != null) {
            String url = this.checkUrlValid(prefix, putMapping.value());
            url = this.mappingAnnotationOne(url, HttpMethod.PUT, clazz, controllerInstance, method);
            urls.add(url);
        }
        if ((deleteMapping = method.getDeclaredAnnotation(DeleteMapping.class)) != null) {
            String url = this.checkUrlValid(prefix, deleteMapping.value());
            url = this.mappingAnnotationOne(url, HttpMethod.DELETE, clazz, controllerInstance, method);
            urls.add(url);
        }
        return urls;
    }

    @Deprecated
    private String mappingAnnotationOne(String url, HttpMethod httpMethod, Class<?> clazz, Object controllerInstance, Method method) throws MappingException {
        if (StringUtils.isBlank(url)) {
            throw new MappingException("URL is Empty in method: " + method);
        }
        Map<HttpMethod, UrlMapping> temp = this.urlMapping.get(url);
        if (temp == null) {
            temp = new HashMap<HttpMethod, UrlMapping>(4);
            this.urlMapping.put(url, temp);
        } else if (temp.containsKey((Object)httpMethod)) {
            throw new MappingException("class: " + clazz + ",method: " + method + ",url: " + url);
        }
        temp.put(httpMethod, new UrlMapping(controllerInstance, method, method.getParameterTypes()));
        return url;
    }
}

