/*
 * Decompiled with CFR 0.152.
 */
package com.coolxiaoyao.common.util;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ClassUtil {
    @NotNull
    public static Set<Class<?>> scannerClassByAnnotation(Class<? extends Annotation> annotationClass, String ... primaryPackages) {
        if (primaryPackages.length == 0) {
            return Collections.emptySet();
        }
        String[] ps = new String[primaryPackages.length];
        for (int i = 0; i < primaryPackages.length; ++i) {
            ps[i] = primaryPackages[i];
        }
        return ClassUtil.scannerClassByAnnotationPackage(annotationClass, ps);
    }

    @NotNull
    public static Set<Class<?>> scannerClassByAnnotation(Class<? extends Annotation> annotationClass, Class<?> ... primaryClass) {
        if (primaryClass.length == 0) {
            return Collections.emptySet();
        }
        String[] pkgs = new String[primaryClass.length];
        for (int i = 0; i < primaryClass.length; ++i) {
            pkgs[i] = primaryClass[i].getPackage().getName();
        }
        return ClassUtil.scannerClassByAnnotation(annotationClass, pkgs);
    }

    @NotNull
    public static Set<Class<?>> scannerClassByAnnotationPackage(Class<? extends Annotation> annotationClass, String[] primaryPkg) {
        HashSet allClass = new HashSet();
        for (String pkg : primaryPkg) {
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(annotationClass);
            allClass.addAll(typesAnnotatedWith);
        }
        return allClass;
    }

    public static boolean supportRequestBodyClassType(Class<?> type) {
        if (type.isPrimitive()) {
            return false;
        }
        if (Number.class.isAssignableFrom(type)) {
            return false;
        }
        if (type == String.class) {
            return true;
        }
        if (type == List.class) {
            return true;
        }
        if (type == Map.class) {
            return true;
        }
        return true;
    }

    public static boolean supportRequestParamClassType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isArray()) {
            return true;
        }
        if (List.class.isAssignableFrom(type)) {
            return true;
        }
        return type == String.class;
    }

    public static boolean supportPathVariableClassType(Class<?> type) {
        if (type == Boolean.TYPE || type == Integer.TYPE || type == Short.TYPE || type == Float.TYPE || type == Double.TYPE || type == Byte.TYPE || type == Long.TYPE || type == Character.TYPE) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        return type == String.class;
    }

    public static Object[] getObjectArrayDefaultValue(Class<?>[] cs) {
        Object[] args = new Object[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            args[i] = ClassUtil.getObjectDefaultValue(cs[i]);
        }
        return args;
    }

    public static Object getObjectDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Short.TYPE) {
                return 0;
            }
            if (clazz == Double.TYPE) {
                return 0.0;
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (clazz == Boolean.TYPE) {
                return false;
            }
            if (clazz == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    }

    public static Object convertValueByClass(Class<?> clazz, String value) {
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                return Byte.parseByte(value);
            }
            if (clazz == Integer.TYPE) {
                return Integer.parseInt(value);
            }
            if (clazz == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (clazz == Short.TYPE) {
                return Short.parseShort(value);
            }
            if (clazz == Double.TYPE) {
                return Double.parseDouble(value);
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.parseBoolean(value);
            }
            if (clazz == Character.TYPE) {
                if (value.length() > 0) {
                    return Character.valueOf(value.toCharArray()[0]);
                }
                return Character.valueOf('\u0000');
            }
        } else {
            if (clazz == Integer.class) {
                return Integer.valueOf(value);
            }
            if (clazz == Long.class) {
                return Long.valueOf(value);
            }
            if (clazz == Short.class) {
                return Short.valueOf(value);
            }
            if (clazz == Boolean.class) {
                return Boolean.valueOf(value);
            }
            if (clazz == Float.class) {
                return Float.valueOf(value);
            }
            if (clazz == Double.class) {
                return Double.valueOf(value);
            }
            if (clazz == Byte.class) {
                return Byte.valueOf(value);
            }
            if (clazz == Character.class) {
                if (value.length() > 0) {
                    return Character.valueOf(value.toCharArray()[0]);
                }
                return Character.valueOf('\u0000');
            }
        }
        return value;
    }
}

