/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.redis;

import com.vcarecity.redis.SerializeUtils;
import com.vcarecity.savedb.util.PropertiesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.SortingParams;

public class RedisClient {
    private static RedisClient instance;
    private Jedis jedis;
    private JedisPool jedisPool;
    private ShardedJedis shardedJedis;
    private ShardedJedisPool shardedJedisPool;
    private final String REDIS_IP = "redis.ip";
    private final String REDIS_PORT = "redis.port";
    private final String REDIS_PROPERTIES_FILE_PATH = "/redis.properties";
    Properties properties = null;
    String redis_ip = null;
    int redis_port = 0;
    String redis_auth = null;

    public static synchronized RedisClient getInstance() {
        if (instance == null) {
            instance = new RedisClient();
        }
        return instance;
    }

    public RedisClient() {
        this.initial();
    }

    private void initial() {
        this.initialProperty();
        this.initialPool();
        this.initialShardedPool();
        this.shardedJedis = this.shardedJedisPool.getResource();
        this.jedis = this.jedisPool.getResource();
        this.jedis.auth(this.redis_auth);
    }

    private void initialProperty() {
        try {
            this.redis_ip = PropertiesUtils.getRedisProperties("redis.ip");
            this.redis_port = Integer.parseInt(PropertiesUtils.getRedisProperties("redis.port"));
            this.redis_auth = PropertiesUtils.getRedisProperties(this.redis_auth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getIntegerValue(String key) {
        int value = 0;
        if (this.properties.containsKey(key)) {
            value = Integer.parseInt(this.properties.getProperty(key).trim());
        }
        return value;
    }

    private void initialPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(5);
        config.setTestOnBorrow(false);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)config, this.redis_ip, this.redis_port);
    }

    private void initialShardedPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(5);
        config.setTestOnBorrow(false);
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        JedisShardInfo si = new JedisShardInfo(this.redis_ip, this.redis_port);
        si.setPassword(this.redis_auth);
        shards.add(si);
        this.shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)config, shards);
    }

    private void KeyOperate() {
        System.out.println("======================key==========================");
        System.out.println("\u6e05\u7a7a\u5e93\u4e2d\u6240\u6709\u6570\u636e\uff1a" + this.jedis.flushDB());
        System.out.println("\u5224\u65adkey999\u952e\u662f\u5426\u5b58\u5728\uff1a" + this.shardedJedis.exists("key999"));
        System.out.println("\u65b0\u589ekey001,value001\u952e\u503c\u5bf9\uff1a" + this.shardedJedis.set("key001", "value001"));
        System.out.println("\u5224\u65adkey001\u662f\u5426\u5b58\u5728\uff1a" + this.shardedJedis.exists("key001"));
        System.out.println("\u65b0\u589ekey002,value002\u952e\u503c\u5bf9\uff1a" + this.shardedJedis.set("key002", "value002"));
        System.out.println("\u7cfb\u7edf\u4e2d\u6240\u6709\u952e\u5982\u4e0b\uff1a");
        Set keys = this.jedis.keys("*");
        for (String key : keys) {
            System.out.println(key);
        }
        System.out.println("\u7cfb\u7edf\u4e2d\u5220\u9664key002: " + this.jedis.del("key002"));
        System.out.println("\u5224\u65adkey002\u662f\u5426\u5b58\u5728\uff1a" + this.shardedJedis.exists("key002"));
        System.out.println("\u8bbe\u7f6e key001\u7684\u8fc7\u671f\u65f6\u95f4\u4e3a5\u79d2:" + this.jedis.expire("key001", 5));
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("\u67e5\u770bkey001\u7684\u5269\u4f59\u751f\u5b58\u65f6\u95f4\uff1a" + this.jedis.ttl("key001"));
        System.out.println("\u79fb\u9664key001\u7684\u751f\u5b58\u65f6\u95f4\uff1a" + this.jedis.persist("key001"));
        System.out.println("\u67e5\u770bkey001\u7684\u5269\u4f59\u751f\u5b58\u65f6\u95f4\uff1a" + this.jedis.ttl("key001"));
        System.out.println("\u67e5\u770bkey\u6240\u50a8\u5b58\u7684\u503c\u7684\u7c7b\u578b\uff1a" + this.jedis.type("key001"));
    }

    private void StringOperate() {
        System.out.println("======================String_1==========================");
        System.out.println("\u6e05\u7a7a\u5e93\u4e2d\u6240\u6709\u6570\u636e\uff1a" + this.jedis.flushDB());
        System.out.println("=============\u589e=============");
        this.jedis.set("key001", "value001");
        this.jedis.set("key002", "value002");
        this.jedis.set("key003", "value003");
        System.out.println("\u5df2\u65b0\u589e\u76843\u4e2a\u952e\u503c\u5bf9\u5982\u4e0b\uff1a");
        System.out.println(this.jedis.get("key001"));
        System.out.println(this.jedis.get("key002"));
        System.out.println(this.jedis.get("key003"));
        System.out.println("=============\u5220=============");
        System.out.println("\u5220\u9664key003\u952e\u503c\u5bf9\uff1a" + this.jedis.del("key003"));
        System.out.println("\u83b7\u53d6key003\u952e\u5bf9\u5e94\u7684\u503c\uff1a" + this.jedis.get("key003"));
        System.out.println("=============\u6539=============");
        System.out.println("\u76f4\u63a5\u8986\u76d6key001\u539f\u6765\u7684\u6570\u636e\uff1a" + this.jedis.set("key001", "value001-update"));
        System.out.println("\u83b7\u53d6key001\u5bf9\u5e94\u7684\u65b0\u503c\uff1a" + this.jedis.get("key001"));
        System.out.println("\u5728key002\u539f\u6765\u503c\u540e\u9762\u8ffd\u52a0\uff1a" + this.jedis.append("key002", "+appendString"));
        System.out.println("\u83b7\u53d6key002\u5bf9\u5e94\u7684\u65b0\u503c" + this.jedis.get("key002"));
        System.out.println("=============\u589e\uff0c\u5220\uff0c\u67e5\uff08\u591a\u4e2a\uff09=============");
        System.out.println("\u4e00\u6b21\u6027\u65b0\u589ekey201,key202,key203,key204\u53ca\u5176\u5bf9\u5e94\u503c\uff1a" + this.jedis.mset(new String[]{"key201", "value201", "key202", "value202", "key203", "value203", "key204", "value204"}));
        System.out.println("\u4e00\u6b21\u6027\u83b7\u53d6key201,key202,key203,key204\u5404\u81ea\u5bf9\u5e94\u7684\u503c\uff1a" + this.jedis.mget(new String[]{"key201", "key202", "key203", "key204"}));
        System.out.println("\u4e00\u6b21\u6027\u5220\u9664key201,key202\uff1a" + this.jedis.del(new String[]{"key201", "key202"}));
        System.out.println("\u4e00\u6b21\u6027\u83b7\u53d6key201,key202,key203,key204\u5404\u81ea\u5bf9\u5e94\u7684\u503c\uff1a" + this.jedis.mget(new String[]{"key201", "key202", "key203", "key204"}));
        System.out.println();
        System.out.println("======================String_2==========================");
        System.out.println("\u6e05\u7a7a\u5e93\u4e2d\u6240\u6709\u6570\u636e\uff1a" + this.jedis.flushDB());
        System.out.println("=============\u65b0\u589e\u952e\u503c\u5bf9\u65f6\u9632\u6b62\u8986\u76d6\u539f\u5148\u503c=============");
        System.out.println("\u539f\u5148key301\u4e0d\u5b58\u5728\u65f6\uff0c\u65b0\u589ekey301\uff1a" + this.shardedJedis.setnx("key301", "value301"));
        System.out.println("\u539f\u5148key302\u4e0d\u5b58\u5728\u65f6\uff0c\u65b0\u589ekey302\uff1a" + this.shardedJedis.setnx("key302", "value302"));
        System.out.println("\u5f53key302\u5b58\u5728\u65f6\uff0c\u5c1d\u8bd5\u65b0\u589ekey302\uff1a" + this.shardedJedis.setnx("key302", "value302_new"));
        System.out.println("\u83b7\u53d6key301\u5bf9\u5e94\u7684\u503c\uff1a" + this.shardedJedis.get("key301"));
        System.out.println("\u83b7\u53d6key302\u5bf9\u5e94\u7684\u503c\uff1a" + this.shardedJedis.get("key302"));
        System.out.println("=============\u8d85\u8fc7\u6709\u6548\u671f\u952e\u503c\u5bf9\u88ab\u5220\u9664=============");
        System.out.println("\u65b0\u589ekey303\uff0c\u5e76\u6307\u5b9a\u8fc7\u671f\u65f6\u95f4\u4e3a2\u79d2" + this.shardedJedis.setex("key303", 2, "key303-2second"));
        System.out.println("\u83b7\u53d6key303\u5bf9\u5e94\u7684\u503c\uff1a" + this.shardedJedis.get("key303"));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("3\u79d2\u4e4b\u540e\uff0c\u83b7\u53d6key303\u5bf9\u5e94\u7684\u503c\uff1a" + this.shardedJedis.get("key303"));
        System.out.println("=============\u83b7\u53d6\u539f\u503c\uff0c\u66f4\u65b0\u4e3a\u65b0\u503c\u4e00\u6b65\u5b8c\u6210=============");
        System.out.println("key302\u539f\u503c\uff1a" + this.shardedJedis.getSet("key302", "value302-after-getset"));
        System.out.println("key302\u65b0\u503c\uff1a" + this.shardedJedis.get("key302"));
        System.out.println("=============\u83b7\u53d6\u5b50\u4e32=============");
        System.out.println("\u83b7\u53d6key302\u5bf9\u5e94\u503c\u4e2d\u7684\u5b50\u4e32\uff1a" + this.shardedJedis.getrange("key302", 5L, 7L));
    }

    private void ListOperate() {
        System.out.println("======================list==========================");
        System.out.println("\u6e05\u7a7a\u5e93\u4e2d\u6240\u6709\u6570\u636e\uff1a" + this.jedis.flushDB());
        System.out.println("=============\u589e=============");
        this.shardedJedis.lpush("stringlists", new String[]{"vector"});
        this.shardedJedis.lpush("stringlists", new String[]{"ArrayList"});
        this.shardedJedis.lpush("stringlists", new String[]{"vector"});
        this.shardedJedis.lpush("stringlists", new String[]{"vector"});
        this.shardedJedis.lpush("stringlists", new String[]{"LinkedList"});
        this.shardedJedis.lpush("stringlists", new String[]{"MapList"});
        this.shardedJedis.lpush("stringlists", new String[]{"SerialList"});
        this.shardedJedis.lpush("stringlists", new String[]{"HashList"});
        this.shardedJedis.lpush("numberlists", new String[]{"3"});
        this.shardedJedis.lpush("numberlists", new String[]{"1"});
        this.shardedJedis.lpush("numberlists", new String[]{"5"});
        this.shardedJedis.lpush("numberlists", new String[]{"2"});
        System.out.println("\u6240\u6709\u5143\u7d20-stringlists\uff1a" + this.shardedJedis.lrange("stringlists", 0L, -1L));
        System.out.println("\u6240\u6709\u5143\u7d20-numberlists\uff1a" + this.shardedJedis.lrange("numberlists", 0L, -1L));
        System.out.println("=============\u5220=============");
        System.out.println("\u6210\u529f\u5220\u9664\u6307\u5b9a\u5143\u7d20\u4e2a\u6570-stringlists\uff1a" + this.shardedJedis.lrem("stringlists", 2L, "vector"));
        System.out.println("\u5220\u9664\u6307\u5b9a\u5143\u7d20\u4e4b\u540e-stringlists\uff1a" + this.shardedJedis.lrange("stringlists", 0L, -1L));
        System.out.println("\u5220\u9664\u4e0b\u68070-3\u533a\u95f4\u4e4b\u5916\u7684\u5143\u7d20\uff1a" + this.shardedJedis.ltrim("stringlists", 0L, 3L));
        System.out.println("\u5220\u9664\u6307\u5b9a\u533a\u95f4\u4e4b\u5916\u5143\u7d20\u540e-stringlists\uff1a" + this.shardedJedis.lrange("stringlists", 0L, -1L));
        System.out.println("\u5143\u7d20\u51fa\u6808\uff1a" + this.shardedJedis.lpop("stringlists"));
        System.out.println("\u5143\u7d20\u51fa\u6808\u540e-stringlists\uff1a" + this.shardedJedis.lrange("stringlists", 0L, -1L));
        System.out.println("\u5143\u7d20\u51fa\u6808\uff1a" + this.shardedJedis.lpop("stringlists"));
        System.out.println("\u5143\u7d20\u51fa\u6808\u540e-stringlists\uff1a" + this.shardedJedis.lrange("stringlists", 0L, -1L));
        System.out.println("=============\u6539=============");
        this.shardedJedis.lset("stringlists", 0L, "hello list!");
        System.out.println("\u4e0b\u6807\u4e3a0\u7684\u503c\u4fee\u6539\u540e-stringlists\uff1a" + this.shardedJedis.lrange("stringlists", 0L, -1L));
        System.out.println("=============\u67e5=============");
        System.out.println("\u957f\u5ea6-stringlists\uff1a" + this.shardedJedis.llen("stringlists"));
        System.out.println("\u957f\u5ea6-numberlists\uff1a" + this.shardedJedis.llen("numberlists"));
        SortingParams sortingParameters = new SortingParams();
        sortingParameters.alpha();
        sortingParameters.limit(0, 3);
        System.out.println("\u8fd4\u56de\u6392\u5e8f\u540e\u7684\u7ed3\u679c-stringlists\uff1a" + this.shardedJedis.sort("stringlists", sortingParameters));
        System.out.println("\u8fd4\u56de\u6392\u5e8f\u540e\u7684\u7ed3\u679c-numberlists\uff1a" + this.shardedJedis.sort("numberlists"));
        System.out.println("\u5b50\u4e32-\u7b2c\u4e8c\u4e2a\u5f00\u59cb\u5230\u7ed3\u675f\uff1a" + this.shardedJedis.lrange("stringlists", 1L, -1L));
        System.out.println("\u83b7\u53d6\u4e0b\u6807\u4e3a2\u7684\u5143\u7d20\uff1a" + this.shardedJedis.lindex("stringlists", 2L) + "\n");
    }

    private void SetOperate() {
        System.out.println("======================set==========================");
        System.out.println("\u6e05\u7a7a\u5e93\u4e2d\u6240\u6709\u6570\u636e\uff1a" + this.jedis.flushDB());
        System.out.println("=============\u589e=============");
        System.out.println("\u5411sets\u96c6\u5408\u4e2d\u52a0\u5165\u5143\u7d20element001\uff1a" + this.jedis.sadd("sets", new String[]{"element001"}));
        System.out.println("\u5411sets\u96c6\u5408\u4e2d\u52a0\u5165\u5143\u7d20element002\uff1a" + this.jedis.sadd("sets", new String[]{"element002"}));
        System.out.println("\u5411sets\u96c6\u5408\u4e2d\u52a0\u5165\u5143\u7d20element003\uff1a" + this.jedis.sadd("sets", new String[]{"element003"}));
        System.out.println("\u5411sets\u96c6\u5408\u4e2d\u52a0\u5165\u5143\u7d20element004\uff1a" + this.jedis.sadd("sets", new String[]{"element004"}));
        System.out.println("\u67e5\u770bsets\u96c6\u5408\u4e2d\u7684\u6240\u6709\u5143\u7d20:" + this.jedis.smembers("sets"));
        System.out.println();
        System.out.println("=============\u5220=============");
        System.out.println("\u96c6\u5408sets\u4e2d\u5220\u9664\u5143\u7d20element003\uff1a" + this.jedis.srem("sets", new String[]{"element003"}));
        System.out.println("\u67e5\u770bsets\u96c6\u5408\u4e2d\u7684\u6240\u6709\u5143\u7d20:" + this.jedis.smembers("sets"));
        System.out.println();
        System.out.println("=============\u6539=============");
        System.out.println();
        System.out.println("=============\u67e5=============");
        System.out.println("\u5224\u65adelement001\u662f\u5426\u5728\u96c6\u5408sets\u4e2d\uff1a" + this.jedis.sismember("sets", "element001"));
        System.out.println("\u5faa\u73af\u67e5\u8be2\u83b7\u53d6sets\u4e2d\u7684\u6bcf\u4e2a\u5143\u7d20\uff1a");
        Set set = this.jedis.smembers("sets");
        for (Object obj : set) {
            System.out.println(obj);
        }
        System.out.println();
        System.out.println("=============\u96c6\u5408\u8fd0\u7b97=============");
        System.out.println("sets1\u4e2d\u6dfb\u52a0\u5143\u7d20element001\uff1a" + this.jedis.sadd("sets1", new String[]{"element001"}));
        System.out.println("sets1\u4e2d\u6dfb\u52a0\u5143\u7d20element002\uff1a" + this.jedis.sadd("sets1", new String[]{"element002"}));
        System.out.println("sets1\u4e2d\u6dfb\u52a0\u5143\u7d20element003\uff1a" + this.jedis.sadd("sets1", new String[]{"element003"}));
        System.out.println("sets1\u4e2d\u6dfb\u52a0\u5143\u7d20element002\uff1a" + this.jedis.sadd("sets2", new String[]{"element002"}));
        System.out.println("sets1\u4e2d\u6dfb\u52a0\u5143\u7d20element003\uff1a" + this.jedis.sadd("sets2", new String[]{"element003"}));
        System.out.println("sets1\u4e2d\u6dfb\u52a0\u5143\u7d20element004\uff1a" + this.jedis.sadd("sets2", new String[]{"element004"}));
        System.out.println("\u67e5\u770bsets1\u96c6\u5408\u4e2d\u7684\u6240\u6709\u5143\u7d20:" + this.jedis.smembers("sets1"));
        System.out.println("\u67e5\u770bsets2\u96c6\u5408\u4e2d\u7684\u6240\u6709\u5143\u7d20:" + this.jedis.smembers("sets2"));
        System.out.println("sets1\u548csets2\u4ea4\u96c6\uff1a" + this.jedis.sinter(new String[]{"sets1", "sets2"}));
        System.out.println("sets1\u548csets2\u5e76\u96c6\uff1a" + this.jedis.sunion(new String[]{"sets1", "sets2"}));
        System.out.println("sets1\u548csets2\u5dee\u96c6\uff1a" + this.jedis.sdiff(new String[]{"sets1", "sets2"}));
    }

    private void SortedSetOperate() {
        System.out.println("======================zset==========================");
        System.out.println(this.jedis.flushDB());
        System.out.println("=============\u589e=============");
        System.out.println("zset\u4e2d\u6dfb\u52a0\u5143\u7d20element001\uff1a" + this.shardedJedis.zadd("zset", 7.0, "element001"));
        System.out.println("zset\u4e2d\u6dfb\u52a0\u5143\u7d20element002\uff1a" + this.shardedJedis.zadd("zset", 8.0, "element002"));
        System.out.println("zset\u4e2d\u6dfb\u52a0\u5143\u7d20element003\uff1a" + this.shardedJedis.zadd("zset", 2.0, "element003"));
        System.out.println("zset\u4e2d\u6dfb\u52a0\u5143\u7d20element004\uff1a" + this.shardedJedis.zadd("zset", 3.0, "element004"));
        System.out.println("zset\u96c6\u5408\u4e2d\u7684\u6240\u6709\u5143\u7d20\uff1a" + this.shardedJedis.zrange("zset", 0L, -1L));
        System.out.println();
        System.out.println("=============\u5220=============");
        System.out.println("zset\u4e2d\u5220\u9664\u5143\u7d20element002\uff1a" + this.shardedJedis.zrem("zset", new String[]{"element002"}));
        System.out.println("zset\u96c6\u5408\u4e2d\u7684\u6240\u6709\u5143\u7d20\uff1a" + this.shardedJedis.zrange("zset", 0L, -1L));
        System.out.println();
        System.out.println("=============\u6539=============");
        System.out.println();
        System.out.println("=============\u67e5=============");
        System.out.println("\u7edf\u8ba1zset\u96c6\u5408\u4e2d\u7684\u5143\u7d20\u4e2d\u4e2a\u6570\uff1a" + this.shardedJedis.zcard("zset"));
        System.out.println("\u7edf\u8ba1zset\u96c6\u5408\u4e2d\u6743\u91cd\u67d0\u4e2a\u8303\u56f4\u5185\uff081.0\u2014\u20145.0\uff09\uff0c\u5143\u7d20\u7684\u4e2a\u6570\uff1a" + this.shardedJedis.zcount("zset", 1.0, 5.0));
        System.out.println("\u67e5\u770bzset\u96c6\u5408\u4e2delement004\u7684\u6743\u91cd\uff1a" + this.shardedJedis.zscore("zset", "element004"));
        System.out.println("\u67e5\u770b\u4e0b\u68071\u52302\u8303\u56f4\u5185\u7684\u5143\u7d20\u503c\uff1a" + this.shardedJedis.zrange("zset", 1L, 2L));
    }

    private void HashOperate() {
        System.out.println("======================hash==========================");
        System.out.println(this.jedis.flushDB());
        System.out.println("=============\u589e=============");
        System.out.println("hashs\u4e2d\u6dfb\u52a0key001\u548cvalue001\u952e\u503c\u5bf9\uff1a" + this.shardedJedis.hset("hashs", "key001", "value001"));
        System.out.println("hashs\u4e2d\u6dfb\u52a0key002\u548cvalue002\u952e\u503c\u5bf9\uff1a" + this.shardedJedis.hset("hashs", "key002", "value002"));
        System.out.println("hashs\u4e2d\u6dfb\u52a0key003\u548cvalue003\u952e\u503c\u5bf9\uff1a" + this.shardedJedis.hset("hashs", "key003", "value003"));
        System.out.println("\u65b0\u589ekey004\u548c4\u7684\u6574\u578b\u952e\u503c\u5bf9\uff1a" + this.shardedJedis.hincrBy("hashs", "key004", 4L));
        System.out.println("hashs\u4e2d\u7684\u6240\u6709\u503c\uff1a" + this.shardedJedis.hvals("hashs"));
        System.out.println();
        System.out.println("=============\u5220=============");
        System.out.println("hashs\u4e2d\u5220\u9664key002\u952e\u503c\u5bf9\uff1a" + this.shardedJedis.hdel("hashs", new String[]{"key002"}));
        System.out.println("hashs\u4e2d\u7684\u6240\u6709\u503c\uff1a" + this.shardedJedis.hvals("hashs"));
        System.out.println();
        System.out.println("=============\u6539=============");
        System.out.println("key004\u6574\u578b\u952e\u503c\u7684\u503c\u589e\u52a0100\uff1a" + this.shardedJedis.hincrBy("hashs", "key004", 100L));
        System.out.println("hashs\u4e2d\u7684\u6240\u6709\u503c\uff1a" + this.shardedJedis.hvals("hashs"));
        System.out.println();
        System.out.println("=============\u67e5=============");
        System.out.println("\u5224\u65adkey003\u662f\u5426\u5b58\u5728\uff1a" + this.shardedJedis.hexists("hashs", "key003"));
        System.out.println("\u83b7\u53d6key004\u5bf9\u5e94\u7684\u503c\uff1a" + this.shardedJedis.hget("hashs", "key004"));
        System.out.println("\u6279\u91cf\u83b7\u53d6key001\u548ckey003\u5bf9\u5e94\u7684\u503c\uff1a" + this.shardedJedis.hmget("hashs", new String[]{"key001", "key003"}));
        System.out.println("\u83b7\u53d6hashs\u4e2d\u6240\u6709\u7684key\uff1a" + this.shardedJedis.hkeys("hashs"));
        System.out.println("\u83b7\u53d6hashs\u4e2d\u6240\u6709\u7684value\uff1a" + this.shardedJedis.hvals("hashs"));
        System.out.println();
    }

    private void testKey() {
        System.out.println("=============key==========================");
        System.out.println(this.jedis.flushDB());
        System.out.println(this.jedis.echo("foo"));
        System.out.println(this.shardedJedis.exists("foo"));
        this.shardedJedis.set("key", "values");
        System.out.println(this.shardedJedis.exists("key"));
    }

    private void testString() {
        System.out.println("=============String==========================");
        System.out.println(this.jedis.flushDB());
        this.shardedJedis.set("foo", "bar");
        System.out.println(this.shardedJedis.get("foo"));
        this.shardedJedis.setnx("foo", "foo not exits");
        System.out.println(this.shardedJedis.get("foo"));
        this.shardedJedis.set("foo", "foo update");
        System.out.println(this.shardedJedis.get("foo"));
        this.shardedJedis.append("foo", " hello, world");
        System.out.println(this.shardedJedis.get("foo"));
        this.shardedJedis.setex("foo", 2, "foo not exits");
        System.out.println(this.shardedJedis.get("foo"));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println(this.shardedJedis.get("foo"));
        this.shardedJedis.set("foo", "foo update");
        System.out.println(this.shardedJedis.getSet("foo", "foo modify"));
        System.out.println(this.shardedJedis.getrange("foo", 1L, 3L));
        System.out.println(this.jedis.mset(new String[]{"mset1", "mvalue1", "mset2", "mvalue2", "mset3", "mvalue3", "mset4", "mvalue4"}));
        System.out.println(this.jedis.mget(new String[]{"mset1", "mset2", "mset3", "mset4"}));
        System.out.println(this.jedis.del(new String[]{"foo", "foo1", "foo3"}));
    }

    private void testList() {
        System.out.println("=============list==========================");
        System.out.println(this.jedis.flushDB());
        this.shardedJedis.lpush("lists", new String[]{"vector"});
        this.shardedJedis.lpush("lists", new String[]{"ArrayList"});
        this.shardedJedis.lpush("lists", new String[]{"LinkedList"});
        System.out.println(this.shardedJedis.llen("lists"));
        System.out.println(this.shardedJedis.sort("lists"));
        System.out.println(this.shardedJedis.lrange("lists", 0L, 3L));
        this.shardedJedis.lset("lists", 0L, "hello list!");
        System.out.println(this.shardedJedis.lindex("lists", 1L));
        System.out.println(this.shardedJedis.lrem("lists", 1L, "vector"));
        System.out.println(this.shardedJedis.ltrim("lists", 0L, 1L));
        System.out.println(this.shardedJedis.lpop("lists"));
        System.out.println(this.shardedJedis.lrange("lists", 0L, -1L));
    }

    private void testSet() {
        System.out.println("=============set==========================");
        System.out.println(this.jedis.flushDB());
        this.shardedJedis.sadd("sets", new String[]{"HashSet"});
        this.shardedJedis.sadd("sets", new String[]{"SortedSet"});
        this.shardedJedis.sadd("sets", new String[]{"TreeSet"});
        System.out.println(this.shardedJedis.sismember("sets", "TreeSet"));
        System.out.println(this.shardedJedis.smembers("sets"));
        System.out.println(this.shardedJedis.srem("sets", new String[]{"SortedSet"}));
        System.out.println(this.shardedJedis.spop("sets"));
        System.out.println(this.shardedJedis.smembers("sets"));
        this.shardedJedis.sadd("sets1", new String[]{"HashSet1"});
        this.shardedJedis.sadd("sets1", new String[]{"SortedSet1"});
        this.shardedJedis.sadd("sets1", new String[]{"TreeSet"});
        this.shardedJedis.sadd("sets2", new String[]{"HashSet2"});
        this.shardedJedis.sadd("sets2", new String[]{"SortedSet1"});
        this.shardedJedis.sadd("sets2", new String[]{"TreeSet1"});
        System.out.println(this.jedis.sinter(new String[]{"sets1", "sets2"}));
        System.out.println(this.jedis.sunion(new String[]{"sets1", "sets2"}));
        System.out.println(this.jedis.sdiff(new String[]{"sets1", "sets2"}));
    }

    private void testSortedSet() {
        System.out.println("=============zset==========================");
        System.out.println(this.jedis.flushDB());
        this.shardedJedis.zadd("zset", 10.1, "hello");
        this.shardedJedis.zadd("zset", 10.0, ":");
        this.shardedJedis.zadd("zset", 9.0, "zset");
        this.shardedJedis.zadd("zset", 11.0, "zset!");
        System.out.println(this.shardedJedis.zcard("zset"));
        System.out.println(this.shardedJedis.zscore("zset", "zset"));
        System.out.println(this.shardedJedis.zrange("zset", 0L, -1L));
        System.out.println(this.shardedJedis.zrem("zset", new String[]{"zset!"}));
        System.out.println(this.shardedJedis.zcount("zset", 9.5, 10.5));
        System.out.println(this.shardedJedis.zrange("zset", 0L, -1L));
    }

    private void testHash() {
        System.out.println("=============hash==========================");
        System.out.println(this.jedis.flushDB());
        this.shardedJedis.hset("hashs", "entryKey", "entryValue");
        this.shardedJedis.hset("hashs", "entryKey1", "entryValue1");
        this.shardedJedis.hset("hashs", "entryKey2", "entryValue2");
        System.out.println(this.shardedJedis.hexists("hashs", "entryKey"));
        System.out.println(this.shardedJedis.hget("hashs", "entryKey"));
        System.out.println(this.shardedJedis.hmget("hashs", new String[]{"entryKey", "entryKey1"}));
        System.out.println(this.shardedJedis.hdel("hashs", new String[]{"entryKey"}));
        System.out.println(this.shardedJedis.hincrBy("hashs", "entryKey", 123L));
        System.out.println(this.shardedJedis.hkeys("hashs"));
        System.out.println(this.shardedJedis.hvals("hashs"));
    }

    public void show() {
        this.SetOperate();
        this.jedisPool.returnResource(this.jedis);
        this.shardedJedisPool.returnResource(this.shardedJedis);
    }

    public String set(byte[] key, byte[] value) {
        return this.shardedJedis.set(key, value);
    }

    public String set(String key, Object object) {
        return this.jedis.set(key.getBytes(), SerializeUtils.serialize(object));
    }

    public Object get(String key) {
        byte[] value = this.jedis.get(key.getBytes());
        return SerializeUtils.unserialize(value);
    }

    public byte[] get(byte[] key) {
        return this.shardedJedis.get(key);
    }

    public boolean del(String key) {
        return this.jedis.del(key.getBytes()) > 0L;
    }

    public long rpush(String key, String value) {
        return this.shardedJedis.rpush(key, new String[]{value});
    }

    public long rpush(byte[] key, byte[] value) {
        return this.shardedJedis.rpush(key, (byte[][])new byte[][]{value});
    }

    public long rpush(String key, byte[] value) {
        return this.shardedJedis.rpush(key.getBytes(), (byte[][])new byte[][]{value});
    }

    public void rpush(String key, String value, long timeout) {
        long ll = System.currentTimeMillis() + timeout;
        this.shardedJedis.rpush(key, new String[]{String.valueOf(ll) + "~" + value});
        this.shardedJedis.sadd("timeout", new String[]{key});
    }

    public void rpush(String key, String[] value, long timeout) {
        long ll = System.currentTimeMillis() + timeout;
        this.shardedJedis.rpush(key, new String[]{String.valueOf(ll) + "~" + value});
        this.shardedJedis.sadd("timeout", new String[]{key});
    }

    public void rpush(String[] key, String[] value, long timeout) {
        long ll = System.currentTimeMillis() + timeout;
        this.shardedJedis.rpush(key.toString(), new String[]{String.valueOf(ll) + "~" + value.toString()});
        this.shardedJedis.sadd("timeout", key);
    }

    public Set<String> smembers(String key) {
        return this.shardedJedis.smembers(key);
    }

    public String lpop(String key) {
        return this.shardedJedis.lpop(key);
    }

    public List<String> lpoprange(String key, long start, long end) {
        List ls = this.shardedJedis.lrange(key, start, end);
        this.shardedJedis.ltrim(key, end, this.shardedJedis.llen(key).longValue());
        return ls;
    }

    public Long llen(String key) {
        return this.shardedJedis.llen(key);
    }

    public List<String> lrange(String key, long start, long end) {
        return this.shardedJedis.lrange(key, start, end);
    }

    public Long lrem(String key, long count, String value) {
        return this.shardedJedis.lrem(key, count, value);
    }

    public String flushDB() {
        return this.jedis.flushDB();
    }

    public void returnResource() {
        this.jedisPool.returnResource(this.jedis);
        this.shardedJedisPool.returnResource(this.shardedJedis);
    }

    public static void main(String[] args) {
        new RedisClient().show();
    }

    public class DataTimeOutThead
    extends Thread {
        public boolean isNumeric(String str) {
            Pattern pattern = Pattern.compile("[0-9]*");
            return pattern.matcher(str).matches();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 5[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

