/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.redis;

import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.PropertiesUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class ShardedJedisUtil {
    private static ShardedJedisUtil instance;
    private Logger log = null;
    private Jedis jedis;
    private JedisPool jedisPool;
    private ShardedJedis shardedJedis;
    private ShardedJedisPool shardedJedisPool;
    private final String REDIS_IP = "redis.ip";
    private final String REDIS_PORT = "redis.port";
    private final String REDIS_AUTH = "redis.auth";
    Properties properties = null;
    String redis_ip = null;
    int redis_port = 0;
    String redis_auth = null;
    int minIdle = 50;
    int maxIdle = 500;
    int maxTotal = 10000;
    long maxWaitMillis = 30000L;
    long minEvictableIdleTimeMillis = 1800000L;
    int numTestsPerEvictionRun = 3;
    long softMinEvictableIdleTimeMillis = 1800000L;
    boolean testOnBorrow = false;
    boolean testOnReturn = true;
    boolean testWhileIdle = false;
    int timeBetweenEvictionRunsMillis = -1;
    boolean blockWhenExhausted = true;
    String evictionPolicyClassName = "org.apache.commons.pool2.impl.DefaultEvictionPolicy";
    boolean jmxEnabled = true;

    public static synchronized ShardedJedisUtil getInstance() {
        if (instance == null) {
            instance = new ShardedJedisUtil();
        } else {
            try {
                instance.get("unitInfoUpdateStamp");
            }
            catch (Exception e) {
                ShardedJedisUtil.instance.log.writeErrorLog("Redis \u8fde\u63a5\u5f02\u5e38,\u91cd\u65b0\u8fde\u63a5!" + e.getMessage());
                e.printStackTrace();
                instance = new ShardedJedisUtil();
            }
        }
        return instance;
    }

    public ShardedJedisUtil() {
        this.initial();
    }

    private void initial() {
        this.initialProperty();
        this.initialPool();
        this.initialShardedPool();
        this.shardedJedis = this.shardedJedisPool.getResource();
        this.jedis = this.jedisPool.getResource();
        this.jedis.auth(this.redis_auth);
    }

    private void initialProperty() {
        try {
            this.properties = PropertiesUtils.getRedisProperties();
            this.redis_ip = PropertiesUtils.getRedisProperties("redis.ip");
            this.redis_port = Integer.parseInt(PropertiesUtils.getRedisProperties("redis.port"));
            this.redis_auth = PropertiesUtils.getRedisProperties("redis.auth");
            this.minIdle = this.getIntegerValue("jedis.pool.minIdle");
            this.maxIdle = this.getIntegerValue("jedis.pool.maxIdle");
            this.maxTotal = this.getIntegerValue("jedis.pool.maxTotal");
            this.maxWaitMillis = this.getLongValue("jedis.pool.maxWaitMillis");
            this.minEvictableIdleTimeMillis = this.getLongValue("jedis.pool.minEvictableIdleTimeMillis");
            this.numTestsPerEvictionRun = this.getIntegerValue("jedis.pool.numTestsPerEvictionRun");
            this.softMinEvictableIdleTimeMillis = this.getLongValue("jedis.pool.softMinEvictableIdleTimeMillis");
            this.testOnBorrow = this.getBooleanValue("jedis.pool.testOnBorrow");
            this.testOnReturn = this.getBooleanValue("jedis.pool.testOnReturn");
            this.testWhileIdle = this.getBooleanValue("jedis.pool.testWhileIdle");
            this.timeBetweenEvictionRunsMillis = this.getIntegerValue("jedis.pool.timeBetweenEvictionRunsMillis");
            this.blockWhenExhausted = this.getBooleanValue("jedis.pool.blockWhenExhausted");
            this.evictionPolicyClassName = this.getStringValue("jedis.pool.evictionPolicyClassName");
            this.jmxEnabled = this.getBooleanValue("jedis.pool.jmxEnabled");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getIntegerValue(String key) {
        int value = 0;
        if (this.properties.containsKey(key)) {
            value = Integer.parseInt(this.properties.getProperty(key).trim());
        }
        return value;
    }

    private void initialPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)config, this.redis_ip, this.redis_port);
    }

    private void initialShardedPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(this.minIdle);
        config.setMaxIdle(this.maxIdle);
        config.setMaxTotal(this.maxTotal);
        config.setMaxWaitMillis(this.maxWaitMillis);
        config.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        config.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        config.setSoftMinEvictableIdleTimeMillis(this.softMinEvictableIdleTimeMillis);
        config.setTestOnBorrow(this.testOnBorrow);
        config.setTestWhileIdle(this.testWhileIdle);
        config.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        config.setBlockWhenExhausted(this.blockWhenExhausted);
        config.setEvictionPolicyClassName(this.evictionPolicyClassName);
        config.setJmxEnabled(this.jmxEnabled);
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        JedisShardInfo si = new JedisShardInfo(this.redis_ip, this.redis_port);
        si.setPassword(this.redis_auth);
        shards.add(si);
        this.shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)config, shards);
    }

    public long getLongValue(String key) {
        long value = 0L;
        if (this.properties.containsKey(key)) {
            value = Long.parseLong(this.properties.getProperty(key).trim());
        }
        return value;
    }

    public String getStringValue(String key) {
        String value = "";
        if (this.properties.containsKey(key)) {
            value = this.properties.getProperty(key).trim();
        }
        return value;
    }

    public boolean getBooleanValue(String key) {
        boolean value = false;
        if (this.properties.containsKey(key)) {
            value = Boolean.parseBoolean(this.properties.getProperty(key).trim());
        }
        return value;
    }

    public String set(String key, String value) {
        return this.shardedJedis.set(key, value);
    }

    public String get(String key) {
        return this.shardedJedis.get(key);
    }

    public Boolean exists(String key) {
        return this.shardedJedis.exists(key);
    }

    public Long del(String key) {
        return this.shardedJedis.del(key);
    }

    public void setex(String key, int timeout, String value) {
        long t = System.nanoTime();
        this.shardedJedis.setex(String.valueOf(t) + "~" + key, timeout, value);
    }

    public int llen(String key) {
        return this.jedis.keys("*" + key).size();
    }

    public List<String> getex(String key, Long maxId) {
        ArrayList<String> ls = new ArrayList<String>();
        long ltimemillis = 0L;
        for (String iKey : this.jedis.keys("*" + key)) {
            String timemillis;
            int inx;
            if (!ShardedJedisUtil.isNotBlank(iKey) || (inx = iKey.indexOf("~")) <= 0 || (ltimemillis = Long.parseLong(timemillis = iKey.substring(0, inx))) <= maxId) continue;
            ls.add(this.shardedJedis.get(iKey));
            ShardedJedisUtil.setLongValue(maxId, ltimemillis);
        }
        return ls;
    }

    public List<String> lrange(String key, Long maxId) {
        List ls = this.shardedJedis.lrange(key, 0L, this.shardedJedis.llen(key).longValue());
        int start = 0;
        int idx = 0;
        long ltimemillis = 0L;
        Iterator iterator = ls.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            if (!ShardedJedisUtil.isNotBlank(s)) continue;
            int inx = s.indexOf("~");
            Long ll = System.nanoTime();
            if (inx <= 0) continue;
            String timemillis = s.substring(0, inx);
            ltimemillis = Long.parseLong(timemillis);
            if (ltimemillis <= maxId) {
                iterator.remove();
            }
            ++idx;
            if (ltimemillis >= ll) continue;
            ++start;
        }
        ShardedJedisUtil.setLongValue(maxId, ltimemillis);
        if (start > 0) {
            this.shardedJedis.ltrim(key, (long)start, this.shardedJedis.llen(key).longValue());
        }
        return ls;
    }

    public long lrange(String key, long maxId, List<String> ls) {
        ls.addAll(this.shardedJedis.lrange(key, 0L, this.shardedJedis.llen(key).longValue()));
        int start = 0;
        int idx = 0;
        long ltimemillis = 0L;
        Iterator<String> iterator = ls.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!ShardedJedisUtil.isNotBlank(s)) continue;
            int inx = s.indexOf("~");
            Long ll = System.nanoTime();
            if (inx <= 0) continue;
            String timemillis = s.substring(0, inx);
            ltimemillis = Long.parseLong(timemillis);
            if (ltimemillis <= maxId) {
                iterator.remove();
            }
            ++idx;
            if (ltimemillis >= ll) continue;
            ++start;
        }
        maxId = ltimemillis;
        if (start > 0) {
            this.shardedJedis.ltrim(key, (long)start, this.shardedJedis.llen(key).longValue());
        }
        return maxId;
    }

    public Long hset(String key, String field, String value) {
        return this.shardedJedis.hset(key, field, value);
    }

    public String hget(String key, String field) {
        return this.shardedJedis.hget(key, field);
    }

    public Boolean hexists(String key, String field) {
        return this.shardedJedis.hexists(key, field);
    }

    public Long hdel(String key, String ... fields) {
        return this.shardedJedis.hdel(key, fields);
    }

    public Long hlen(String key) {
        return this.shardedJedis.hlen(key);
    }

    public Set<String> hkeys(String key) {
        return this.shardedJedis.hkeys(key);
    }

    public List<String> hvals(String key) {
        return this.shardedJedis.hvals(key);
    }

    public String hmset(String key, Map<String, String> hash) {
        return this.shardedJedis.hmset(key, hash);
    }

    public List<String> hmget(String key, String ... fields) {
        return this.shardedJedis.hmget(key, fields);
    }

    public Long sadd(String key, String ... members) {
        return this.shardedJedis.sadd(key, members);
    }

    public Set<String> smembers(String key) {
        return this.shardedJedis.smembers(key);
    }

    public Long srem(String key, String ... members) {
        return this.shardedJedis.srem(key, members);
    }

    public static boolean isNotBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0 || "null".equalsIgnoreCase(str)) {
            return false;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean setLongValue(Long oldValue, long newValue) {
        try {
            Field field = Long.class.getDeclaredField("value");
            field.setAccessible(true);
            field.setLong(oldValue, newValue);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String flushDB() {
        return this.jedis.flushDB();
    }

    public void returnResource() {
        this.jedisPool.returnResource(this.jedis);
        this.shardedJedisPool.returnResource(this.shardedJedis);
    }

    public static void main(String[] args) {
        JSONObject jb1;
        ShardedJedisUtil JedisUtilBean = new ShardedJedisUtil();
        System.out.println("\u53d6\u8bbe\u5907\u8d44\u6599\u6570:" + JedisUtilBean.hlen("unitInfo"));
        System.out.println("\u53d6\u8bbe\u5907\u8d44\u6599:" + JedisUtilBean.hget("unitInfo", "/0/002315110001/1/19-2-44/"));
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("UNIT_PATH", "/-299/14/15/26905/");
        hm.put("UNIT_STATE_ID", "224");
        hm.put("LON", "106.535615");
        hm.put("FLOOR_ID", "204");
        JSONObject jb = JSONObject.fromObject(hm);
        JSONObject map1 = jb1 = JSONObject.fromObject((Object)jb.toString());
        System.out.println(map1.get("UNIT_PATH"));
    }
}

