/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb;

import com.vcarecity.savedb.cache.DataCache;
import com.vcarecity.savedb.cache.DefaultDataCache;
import com.vcarecity.savedb.log.LogManager;
import com.vcarecity.savedb.mq.DefaultActiveMQReader;
import com.vcarecity.savedb.mq.MQManager;
import com.vcarecity.savedb.util.PropertiesUtils;
import com.vcarecity.savedb.util.TimeUtil;
import com.vcarecity.savedb.writer.OracleWriter;
import com.vcarecity.savedb.writer.OracleWriterFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.StringUtil;

public class BatchSaveDB {
    private Logger logger_exception = Logger.getLogger((String)"nameException");
    private List<DataCache> cacheList = new ArrayList<DataCache>();
    private List<OracleWriter> writerList = new ArrayList<OracleWriter>();

    public void exceptionCaught(Throwable e) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        this.logger_exception.info((Object)bos.toString());
    }

    public void startService() throws Exception {
        String[] mqs;
        LogManager.init();
        MQManager.init();
        String[] stringArray = mqs = PropertiesUtils.getMqProperty("queues").split(";");
        int n = mqs.length;
        int n2 = 0;
        while (n2 < n) {
            String queue_name = stringArray[n2];
            String o = PropertiesUtils.getMqProperty("queue_direction_" + queue_name);
            if (StringUtil.isNotBlank((String)o)) {
                int queue_direction = Integer.valueOf(o);
                if (queue_direction == 1) {
                    this.startOne(queue_name);
                }
            } else {
                System.out.println("BatchSaveDB-startService() \u672a\u627e\u5230\u5bf9\u5e94\u7684\u961f\u5217\u540d\u79f0:" + queue_name);
            }
            ++n2;
        }
        System.out.println("[" + TimeUtil.getLocalTime() + "]BatchSaveDB ready!");
    }

    private void startOne(String typeName) throws Exception {
        int cache_size = Integer.valueOf(PropertiesUtils.getMqProperty("cache_size_" + typeName));
        String queue_name = PropertiesUtils.getMqProperty("queue_name_" + typeName);
        int queue_type = Integer.valueOf(PropertiesUtils.getMqProperty("queue_type_" + typeName));
        int batch_size = Integer.valueOf(PropertiesUtils.getMqProperty("batch_size_" + typeName));
        try {
            DefaultDataCache cache = new DefaultDataCache();
            this.cacheList.add(cache);
            cache.setName(String.valueOf(typeName) + " Cache");
            cache.setMaxCacheSize(cache_size);
            OracleWriter writer = OracleWriterFactory.getWriter(typeName);
            this.writerList.add(writer);
            writer.setBatchSize(batch_size);
            writer.setName(String.valueOf(typeName) + " Writer");
            writer.setBatchSave(this);
            writer.setDataCache(cache);
            writer.init();
            writer.startWrite();
            DefaultActiveMQReader reader = new DefaultActiveMQReader(String.valueOf(typeName) + " Reader");
            reader.setBatchSave(this);
            reader.setDataCache(cache);
            reader.setQueueName(queue_name);
            reader.setQueueType(queue_type);
            reader.init();
            reader.startRead();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<OracleWriter> getWriterList() {
        return this.writerList;
    }

    public List<DataCache> getCacheList() {
        return this.cacheList;
    }
}

