/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb;

import com.vcarecity.savedb.log.LogManager;
import com.vcarecity.savedb.mq.DefaultActiveMQWriter;
import com.vcarecity.savedb.mq.MQManager;
import com.vcarecity.savedb.util.PropertiesUtils;
import com.vcarecity.savedb.util.TimeUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.StringUtil;

public class MQWorker {
    private static MQWorker instance;
    private Logger logger_exception = Logger.getLogger((String)"nameException");
    private static Map writerMap;

    static {
        writerMap = new HashMap();
    }

    public static synchronized MQWorker getInstance() {
        if (instance == null) {
            instance = new MQWorker();
        }
        return instance;
    }

    private MQWorker() {
        this.startService();
    }

    public void exceptionCaught(Throwable e) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        this.logger_exception.info((Object)bos.toString());
    }

    private void startService() {
        String[] mqs;
        LogManager.init();
        MQManager.init();
        String[] stringArray = mqs = PropertiesUtils.getMqProperty("queues").split(";");
        int n = mqs.length;
        int n2 = 0;
        while (n2 < n) {
            String queue_name = stringArray[n2];
            String o = PropertiesUtils.getMqProperty("queue_direction_" + queue_name);
            if (StringUtil.isNotBlank((String)o)) {
                int queue_direction = Integer.valueOf(o);
                if (queue_direction == 2) {
                    this.startOne(queue_name);
                }
            } else {
                System.out.println("MQWorker-startService() \u672a\u627e\u5230\u5bf9\u5e94\u7684\u961f\u5217\u540d\u79f0:" + queue_name);
            }
            ++n2;
        }
        System.out.println("[" + TimeUtil.getLocalTime() + "]MQWorker ready!");
    }

    public static DefaultActiveMQWriter getWriter(String writername) {
        DefaultActiveMQWriter writer = (DefaultActiveMQWriter)writerMap.get(String.valueOf(writername) + "Writer");
        return writer;
    }

    public void setWriter(String writername, DefaultActiveMQWriter writer) {
        writerMap.put(writername, writer);
    }

    private void startOne(String typeName) {
        int cache_size = Integer.valueOf(PropertiesUtils.getMqProperty("cache_size_" + typeName));
        String queue_name = PropertiesUtils.getMqProperty("queue_name_" + typeName);
        int queue_type = Integer.valueOf(PropertiesUtils.getMqProperty("queue_type_" + typeName));
        int batch_size = Integer.valueOf(PropertiesUtils.getMqProperty("batch_size_" + typeName));
        try {
            DefaultActiveMQWriter writer = new DefaultActiveMQWriter(String.valueOf(typeName) + " Writer");
            writer.setName(typeName);
            writer.setQueueName(queue_name);
            writer.setQueueType(queue_type);
            this.setWriter(String.valueOf(typeName) + "Writer", writer);
            writer.init();
            writer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

