/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.database;

import com.vcarecity.savedb.database.ConnectionManager;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class Unit {
    Logger logger = Logger.getLogger();

    public JSONObject getOnLineCheckData() {
        JSONObject reObj;
        block6: {
            Connection conn = null;
            PreparedStatement pstam = null;
            ResultSet rs = null;
            reObj = new JSONObject();
            StringBuffer SQLStr = new StringBuffer();
            SQLStr.append(" SELECT T.USER_CODE AS UNITNO, ");
            SQLStr.append("        T.EQUIPMENT_NO AS EQUIPMENTNO, ");
            SQLStr.append("        DECODE(T.GATEWAY_NO, NULL, 0, T.GATEWAY_NO) AS GATEWAYNO ");
            SQLStr.append("   FROM T_UNIT T ");
            SQLStr.append("  WHERE REGEXP_COUNT(T.PUSER_CODE, '/') < 4 ");
            SQLStr.append("    AND T.ISDELETED = 0 ");
            try {
                try {
                    conn = ConnectionManager.openConnection();
                    pstam = conn.prepareStatement(SQLStr.toString());
                    rs = pstam.executeQuery();
                    JSONObject obj = new JSONObject();
                    JSONArray arr = new JSONArray();
                    while (rs.next()) {
                        obj = new JSONObject();
                        obj.put((Object)"unitNo", (Object)rs.getString("UNITNO"));
                        obj.put((Object)"equipmentNo", (Object)rs.getString("EQUIPMENTNO"));
                        obj.put((Object)"gatewayNo", (Object)rs.getString("GATEWAYNO"));
                        arr.add((Object)obj);
                    }
                    reObj.put((Object)"units", (Object)arr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtil.closeDB(rs, pstam, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        this.logger.writeDebugLog("reObj.toString():" + reObj.toString());
        return reObj;
    }

    public JSONObject waterRegister(String ccid) {
        JSONObject reObj;
        block7: {
            Connection conn = null;
            CallableStatement cstam = null;
            reObj = new JSONObject();
            StringBuffer SQLStr = new StringBuffer();
            SQLStr.append(" {call P_INSERTT_UNIT_REGINFO(?,?)} ");
            try {
                try {
                    conn = ConnectionManager.openConnection();
                    cstam = conn.prepareCall(SQLStr.toString());
                    cstam.setString(1, ccid);
                    cstam.registerOutParameter(2, 12);
                    cstam.execute();
                    String deviceId = cstam.getString(2);
                    String status = "01";
                    if (StringUtils.isBlank((String)deviceId) || deviceId.length() < 8) {
                        status = "01";
                        deviceId = ccid;
                    } else {
                        status = "00";
                    }
                    reObj.put((Object)"ccid", (Object)ccid);
                    reObj.put((Object)"deviceId", (Object)deviceId);
                    reObj.put((Object)"status", (Object)status);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtil.closeDB(null, cstam, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(null, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(null, cstam, conn);
        }
        return reObj;
    }

    public JSONObject dtuRegister(String user_code, String imei) {
        JSONObject reObj;
        block5: {
            Connection conn = null;
            CallableStatement cstam = null;
            reObj = new JSONObject();
            StringBuffer SQLStr = new StringBuffer();
            SQLStr.append(" {call P_INSERTT_DTU_REGINFO(?,?,?)} ");
            try {
                try {
                    conn = ConnectionManager.openConnection();
                    cstam = conn.prepareCall(SQLStr.toString());
                    cstam.setString(1, user_code);
                    cstam.setString(2, imei);
                    cstam.registerOutParameter(3, 12);
                    cstam.execute();
                    int is_reg = cstam.getInt(3);
                    reObj.put((Object)"status", (Object)String.valueOf(is_reg));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtil.closeDB(null, cstam, conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(null, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(null, cstam, conn);
        }
        return reObj;
    }

    public int updateUnitCCID(String ccid, String unitno) {
        int ret;
        block5: {
            Connection conn = null;
            CallableStatement cstam = null;
            JSONObject reObj = new JSONObject();
            StringBuffer SQLStr = new StringBuffer();
            SQLStr.append(" {call P_UPDATE_UNIT_LOGIN(?,?,?)} ");
            ret = 1;
            try {
                try {
                    conn = ConnectionManager.openConnection();
                    cstam = conn.prepareCall(SQLStr.toString());
                    cstam.setString(1, ccid);
                    cstam.setString(2, unitno);
                    cstam.registerOutParameter(3, 12);
                    cstam.executeUpdate();
                    ret = cstam.getInt(3);
                    reObj.put((Object)"ret", (Object)String.valueOf(ret));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtil.closeDB(null, cstam, conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(null, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(null, cstam, conn);
        }
        return ret;
    }

    public void updateUnitCCID(String unitno) {
        block5: {
            Connection conn = null;
            CallableStatement cstam = null;
            StringBuffer SQLStr = new StringBuffer();
            SQLStr.append(" {call P_UPDATE_UNIT_CCID(?)} ");
            try {
                try {
                    conn = ConnectionManager.openConnection();
                    cstam = conn.prepareCall(SQLStr.toString());
                    cstam.setString(1, unitno);
                    cstam.execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtil.closeDB(null, cstam, conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(null, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(null, cstam, conn);
        }
    }

    public static void main(String[] args) {
        Unit databean = new Unit();
        JSONObject ls = databean.getOnLineCheckData();
    }
}

